@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.RestResponseRegexArgs.builder
import com.pulumi.azurenative.deploymentmanager.kotlin.enums.RestMatchQuantifier
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The regular expressions to match the response content with.
 * @property matchQuantifier Indicates whether any or all of the expressions should match with the response content.
 * @property matches The list of regular expressions.
 */
public data class RestResponseRegexArgs(
    public val matchQuantifier: Output<RestMatchQuantifier>? = null,
    public val matches: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.RestResponseRegexArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.RestResponseRegexArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.RestResponseRegexArgs.builder()
            .matchQuantifier(matchQuantifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .matches(matches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RestResponseRegexArgs].
 */
@PulumiTagMarker
public class RestResponseRegexArgsBuilder internal constructor() {
    private var matchQuantifier: Output<RestMatchQuantifier>? = null

    private var matches: Output<List<String>>? = null

    /**
     * @param value Indicates whether any or all of the expressions should match with the response content.
     */
    @JvmName("sltpqcqfjgtyawho")
    public suspend fun matchQuantifier(`value`: Output<RestMatchQuantifier>) {
        this.matchQuantifier = value
    }

    /**
     * @param value The list of regular expressions.
     */
    @JvmName("fdjiswdrbeeagbmi")
    public suspend fun matches(`value`: Output<List<String>>) {
        this.matches = value
    }

    @JvmName("usdfkbmgrlwqfifj")
    public suspend fun matches(vararg values: Output<String>) {
        this.matches = Output.all(values.asList())
    }

    /**
     * @param values The list of regular expressions.
     */
    @JvmName("fidswoxwmefxqbuv")
    public suspend fun matches(values: List<Output<String>>) {
        this.matches = Output.all(values)
    }

    /**
     * @param value Indicates whether any or all of the expressions should match with the response content.
     */
    @JvmName("sjqtnrhbogjxbbpw")
    public suspend fun matchQuantifier(`value`: RestMatchQuantifier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchQuantifier = mapped
    }

    /**
     * @param value The list of regular expressions.
     */
    @JvmName("gchoygmdfqtkoygy")
    public suspend fun matches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matches = mapped
    }

    /**
     * @param values The list of regular expressions.
     */
    @JvmName("lnnrvruswwsbriov")
    public suspend fun matches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matches = mapped
    }

    internal fun build(): RestResponseRegexArgs = RestResponseRegexArgs(
        matchQuantifier = matchQuantifier,
        matches = matches,
    )
}
