@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.RolloutIdentityAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * RolloutIdentity uses the user-assigned managed identity authentication context specified in the Identity property during rollout creation.
 * @property type The authentication type.
 * Expected value is 'RolloutIdentity'.
 */
public data class RolloutIdentityAuthenticationArgs(
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.RolloutIdentityAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.deploymentmanager.inputs.RolloutIdentityAuthenticationArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.RolloutIdentityAuthenticationArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RolloutIdentityAuthenticationArgs].
 */
@PulumiTagMarker
public class RolloutIdentityAuthenticationArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The authentication type.
     * Expected value is 'RolloutIdentity'.
     */
    @JvmName("cdlccnhmuqssvybh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The authentication type.
     * Expected value is 'RolloutIdentity'.
     */
    @JvmName("ydhcvyyxgceoguha")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RolloutIdentityAuthenticationArgs = RolloutIdentityAuthenticationArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
