@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.SasAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the properties to access the artifacts using an Azure Storage SAS URI.
 * @property sasUri The SAS URI to the Azure Storage blob container. Any offset from the root of the container to where the artifacts are located can be defined in the artifactRoot.
 * @property type The authentication type
 * Expected value is 'Sas'.
 */
public data class SasAuthenticationArgs(
    public val sasUri: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.SasAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.SasAuthenticationArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.SasAuthenticationArgs.builder()
            .sasUri(sasUri.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SasAuthenticationArgs].
 */
@PulumiTagMarker
public class SasAuthenticationArgsBuilder internal constructor() {
    private var sasUri: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The SAS URI to the Azure Storage blob container. Any offset from the root of the container to where the artifacts are located can be defined in the artifactRoot.
     */
    @JvmName("gtqvkxwcusmirrvv")
    public suspend fun sasUri(`value`: Output<String>) {
        this.sasUri = value
    }

    /**
     * @param value The authentication type
     * Expected value is 'Sas'.
     */
    @JvmName("iajgjbwcfyseyxja")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The SAS URI to the Azure Storage blob container. Any offset from the root of the container to where the artifacts are located can be defined in the artifactRoot.
     */
    @JvmName("sldhmlocoslgugmo")
    public suspend fun sasUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sasUri = mapped
    }

    /**
     * @param value The authentication type
     * Expected value is 'Sas'.
     */
    @JvmName("gftfsgnxktjjtqqi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SasAuthenticationArgs = SasAuthenticationArgs(
        sasUri = sasUri ?: throw PulumiNullFieldException("sasUri"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
