@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.ServiceUnitArtifactsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the artifacts of a service unit.
 * @property parametersArtifactSourceRelativePath The path to the ARM parameters file relative to the artifact source.
 * @property parametersUri The full URI of the ARM parameters file with the SAS token.
 * @property templateArtifactSourceRelativePath The path to the ARM template file relative to the artifact source.
 * @property templateUri The full URI of the ARM template file with the SAS token.
 */
public data class ServiceUnitArtifactsArgs(
    public val parametersArtifactSourceRelativePath: Output<String>? = null,
    public val parametersUri: Output<String>? = null,
    public val templateArtifactSourceRelativePath: Output<String>? = null,
    public val templateUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.ServiceUnitArtifactsArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.ServiceUnitArtifactsArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.ServiceUnitArtifactsArgs.builder()
            .parametersArtifactSourceRelativePath(
                parametersArtifactSourceRelativePath?.applyValue({ args0 ->
                    args0
                }),
            )
            .parametersUri(parametersUri?.applyValue({ args0 -> args0 }))
            .templateArtifactSourceRelativePath(
                templateArtifactSourceRelativePath?.applyValue({ args0 ->
                    args0
                }),
            )
            .templateUri(templateUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceUnitArtifactsArgs].
 */
@PulumiTagMarker
public class ServiceUnitArtifactsArgsBuilder internal constructor() {
    private var parametersArtifactSourceRelativePath: Output<String>? = null

    private var parametersUri: Output<String>? = null

    private var templateArtifactSourceRelativePath: Output<String>? = null

    private var templateUri: Output<String>? = null

    /**
     * @param value The path to the ARM parameters file relative to the artifact source.
     */
    @JvmName("vnrinyfsqjkemkgn")
    public suspend fun parametersArtifactSourceRelativePath(`value`: Output<String>) {
        this.parametersArtifactSourceRelativePath = value
    }

    /**
     * @param value The full URI of the ARM parameters file with the SAS token.
     */
    @JvmName("wldyfqkiitcemmxg")
    public suspend fun parametersUri(`value`: Output<String>) {
        this.parametersUri = value
    }

    /**
     * @param value The path to the ARM template file relative to the artifact source.
     */
    @JvmName("xbxlfyljglareqth")
    public suspend fun templateArtifactSourceRelativePath(`value`: Output<String>) {
        this.templateArtifactSourceRelativePath = value
    }

    /**
     * @param value The full URI of the ARM template file with the SAS token.
     */
    @JvmName("fwtwsappspggcgrw")
    public suspend fun templateUri(`value`: Output<String>) {
        this.templateUri = value
    }

    /**
     * @param value The path to the ARM parameters file relative to the artifact source.
     */
    @JvmName("loamuxsevdgrrknv")
    public suspend fun parametersArtifactSourceRelativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parametersArtifactSourceRelativePath = mapped
    }

    /**
     * @param value The full URI of the ARM parameters file with the SAS token.
     */
    @JvmName("qiuqludelsrbgxko")
    public suspend fun parametersUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parametersUri = mapped
    }

    /**
     * @param value The path to the ARM template file relative to the artifact source.
     */
    @JvmName("lqxcrdesqqjrqcmo")
    public suspend fun templateArtifactSourceRelativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateArtifactSourceRelativePath = mapped
    }

    /**
     * @param value The full URI of the ARM template file with the SAS token.
     */
    @JvmName("iwokyyfaieulnnrr")
    public suspend fun templateUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUri = mapped
    }

    internal fun build(): ServiceUnitArtifactsArgs = ServiceUnitArtifactsArgs(
        parametersArtifactSourceRelativePath = parametersArtifactSourceRelativePath,
        parametersUri = parametersUri,
        templateArtifactSourceRelativePath = templateArtifactSourceRelativePath,
        templateUri = templateUri,
    )
}
