@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.StepGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties that define a Step group in a rollout.
 * @property dependsOnStepGroups The list of step group names on which this step group depends on.
 * @property deploymentTargetId The resource Id of service unit to be deployed. The service unit should be from the service topology referenced in targetServiceTopologyId
 * @property name The name of the step group.
 * @property postDeploymentSteps The list of steps to be run after deploying the target.
 * @property preDeploymentSteps The list of steps to be run before deploying the target.
 */
public data class StepGroupArgs(
    public val dependsOnStepGroups: Output<List<String>>? = null,
    public val deploymentTargetId: Output<String>,
    public val name: Output<String>,
    public val postDeploymentSteps: Output<List<PrePostStepArgs>>? = null,
    public val preDeploymentSteps: Output<List<PrePostStepArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.StepGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.StepGroupArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.StepGroupArgs.builder()
            .dependsOnStepGroups(dependsOnStepGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .deploymentTargetId(deploymentTargetId.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .postDeploymentSteps(
                postDeploymentSteps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .preDeploymentSteps(
                preDeploymentSteps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [StepGroupArgs].
 */
@PulumiTagMarker
public class StepGroupArgsBuilder internal constructor() {
    private var dependsOnStepGroups: Output<List<String>>? = null

    private var deploymentTargetId: Output<String>? = null

    private var name: Output<String>? = null

    private var postDeploymentSteps: Output<List<PrePostStepArgs>>? = null

    private var preDeploymentSteps: Output<List<PrePostStepArgs>>? = null

    /**
     * @param value The list of step group names on which this step group depends on.
     */
    @JvmName("vhmqtwyscdesyadi")
    public suspend fun dependsOnStepGroups(`value`: Output<List<String>>) {
        this.dependsOnStepGroups = value
    }

    @JvmName("qrubmrlurarwlgtq")
    public suspend fun dependsOnStepGroups(vararg values: Output<String>) {
        this.dependsOnStepGroups = Output.all(values.asList())
    }

    /**
     * @param values The list of step group names on which this step group depends on.
     */
    @JvmName("qvylnbeunnnmdgie")
    public suspend fun dependsOnStepGroups(values: List<Output<String>>) {
        this.dependsOnStepGroups = Output.all(values)
    }

    /**
     * @param value The resource Id of service unit to be deployed. The service unit should be from the service topology referenced in targetServiceTopologyId
     */
    @JvmName("fyyrjdskahjptffp")
    public suspend fun deploymentTargetId(`value`: Output<String>) {
        this.deploymentTargetId = value
    }

    /**
     * @param value The name of the step group.
     */
    @JvmName("ynfcnnfmctdqmfcj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The list of steps to be run after deploying the target.
     */
    @JvmName("fkfubrntuhybvnfj")
    public suspend fun postDeploymentSteps(`value`: Output<List<PrePostStepArgs>>) {
        this.postDeploymentSteps = value
    }

    @JvmName("iosguqxqoduuqhka")
    public suspend fun postDeploymentSteps(vararg values: Output<PrePostStepArgs>) {
        this.postDeploymentSteps = Output.all(values.asList())
    }

    /**
     * @param values The list of steps to be run after deploying the target.
     */
    @JvmName("dlvyqekituyrbxpn")
    public suspend fun postDeploymentSteps(values: List<Output<PrePostStepArgs>>) {
        this.postDeploymentSteps = Output.all(values)
    }

    /**
     * @param value The list of steps to be run before deploying the target.
     */
    @JvmName("eosoowydspdbtxuj")
    public suspend fun preDeploymentSteps(`value`: Output<List<PrePostStepArgs>>) {
        this.preDeploymentSteps = value
    }

    @JvmName("fcmsmgkhqamfftka")
    public suspend fun preDeploymentSteps(vararg values: Output<PrePostStepArgs>) {
        this.preDeploymentSteps = Output.all(values.asList())
    }

    /**
     * @param values The list of steps to be run before deploying the target.
     */
    @JvmName("myikcekcqvfaphxy")
    public suspend fun preDeploymentSteps(values: List<Output<PrePostStepArgs>>) {
        this.preDeploymentSteps = Output.all(values)
    }

    /**
     * @param value The list of step group names on which this step group depends on.
     */
    @JvmName("iuddlacrsnjrrfgo")
    public suspend fun dependsOnStepGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOnStepGroups = mapped
    }

    /**
     * @param values The list of step group names on which this step group depends on.
     */
    @JvmName("nnhimyvujislebvx")
    public suspend fun dependsOnStepGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOnStepGroups = mapped
    }

    /**
     * @param value The resource Id of service unit to be deployed. The service unit should be from the service topology referenced in targetServiceTopologyId
     */
    @JvmName("ewvwlcqwseupcmal")
    public suspend fun deploymentTargetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentTargetId = mapped
    }

    /**
     * @param value The name of the step group.
     */
    @JvmName("xhakgwupsjboqdhi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The list of steps to be run after deploying the target.
     */
    @JvmName("dlkywdcoyrfqkxso")
    public suspend fun postDeploymentSteps(`value`: List<PrePostStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postDeploymentSteps = mapped
    }

    /**
     * @param argument The list of steps to be run after deploying the target.
     */
    @JvmName("rhoxldejqtaoyxfe")
    public suspend
    fun postDeploymentSteps(argument: List<suspend PrePostStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PrePostStepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.postDeploymentSteps = mapped
    }

    /**
     * @param argument The list of steps to be run after deploying the target.
     */
    @JvmName("btgsjmwocdbuprhe")
    public suspend fun postDeploymentSteps(
        vararg
        argument: suspend PrePostStepArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { PrePostStepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.postDeploymentSteps = mapped
    }

    /**
     * @param argument The list of steps to be run after deploying the target.
     */
    @JvmName("dsrhibwcheojbksv")
    public suspend fun postDeploymentSteps(argument: suspend PrePostStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrePostStepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.postDeploymentSteps = mapped
    }

    /**
     * @param values The list of steps to be run after deploying the target.
     */
    @JvmName("dlgdfrlnpxykqlar")
    public suspend fun postDeploymentSteps(vararg values: PrePostStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.postDeploymentSteps = mapped
    }

    /**
     * @param value The list of steps to be run before deploying the target.
     */
    @JvmName("wbdkkdbasaobmqte")
    public suspend fun preDeploymentSteps(`value`: List<PrePostStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preDeploymentSteps = mapped
    }

    /**
     * @param argument The list of steps to be run before deploying the target.
     */
    @JvmName("elytqudwrxrtvhyu")
    public suspend fun preDeploymentSteps(argument: List<suspend PrePostStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PrePostStepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.preDeploymentSteps = mapped
    }

    /**
     * @param argument The list of steps to be run before deploying the target.
     */
    @JvmName("pigxbibaibxetjbf")
    public suspend fun preDeploymentSteps(
        vararg
        argument: suspend PrePostStepArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { PrePostStepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.preDeploymentSteps = mapped
    }

    /**
     * @param argument The list of steps to be run before deploying the target.
     */
    @JvmName("sdkwyuofsfhesotj")
    public suspend fun preDeploymentSteps(argument: suspend PrePostStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrePostStepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.preDeploymentSteps = mapped
    }

    /**
     * @param values The list of steps to be run before deploying the target.
     */
    @JvmName("uroqrreyfbvegtxc")
    public suspend fun preDeploymentSteps(vararg values: PrePostStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preDeploymentSteps = mapped
    }

    internal fun build(): StepGroupArgs = StepGroupArgs(
        dependsOnStepGroups = dependsOnStepGroups,
        deploymentTargetId = deploymentTargetId ?: throw PulumiNullFieldException("deploymentTargetId"),
        name = name ?: throw PulumiNullFieldException("name"),
        postDeploymentSteps = postDeploymentSteps,
        preDeploymentSteps = preDeploymentSteps,
    )
}
