@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.WaitStepAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters for the wait step.
 * @property duration The duration in ISO 8601 format of how long the wait should be.
 */
public data class WaitStepAttributesArgs(
    public val duration: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.WaitStepAttributesArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.WaitStepAttributesArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.WaitStepAttributesArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WaitStepAttributesArgs].
 */
@PulumiTagMarker
public class WaitStepAttributesArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    /**
     * @param value The duration in ISO 8601 format of how long the wait should be.
     */
    @JvmName("tlajxigfeocotcrx")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value The duration in ISO 8601 format of how long the wait should be.
     */
    @JvmName("ujeasgkemliyxqds")
    public suspend fun duration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    internal fun build(): WaitStepAttributesArgs = WaitStepAttributesArgs(
        duration = duration ?: throw PulumiNullFieldException("duration"),
    )
}
