@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.WaitStepPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the properties of a Wait step.
 * @property attributes The Wait attributes
 * @property stepType The type of step.
 * Expected value is 'Wait'.
 */
public data class WaitStepPropertiesArgs(
    public val attributes: Output<WaitStepAttributesArgs>,
    public val stepType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.WaitStepPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.WaitStepPropertiesArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.WaitStepPropertiesArgs.builder()
            .attributes(attributes.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stepType(stepType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WaitStepPropertiesArgs].
 */
@PulumiTagMarker
public class WaitStepPropertiesArgsBuilder internal constructor() {
    private var attributes: Output<WaitStepAttributesArgs>? = null

    private var stepType: Output<String>? = null

    /**
     * @param value The Wait attributes
     */
    @JvmName("utfopxiainyehvqi")
    public suspend fun attributes(`value`: Output<WaitStepAttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value The type of step.
     * Expected value is 'Wait'.
     */
    @JvmName("qbbxgvvxusvssgxu")
    public suspend fun stepType(`value`: Output<String>) {
        this.stepType = value
    }

    /**
     * @param value The Wait attributes
     */
    @JvmName("ujxerijmnbqsgufb")
    public suspend fun attributes(`value`: WaitStepAttributesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The Wait attributes
     */
    @JvmName("uvjdsrpeijxbxdaa")
    public suspend fun attributes(argument: suspend WaitStepAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = WaitStepAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value The type of step.
     * Expected value is 'Wait'.
     */
    @JvmName("lwgrgyaqudnnadjf")
    public suspend fun stepType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stepType = mapped
    }

    internal fun build(): WaitStepPropertiesArgs = WaitStepPropertiesArgs(
        attributes = attributes ?: throw PulumiNullFieldException("attributes"),
        stepType = stepType ?: throw PulumiNullFieldException("stepType"),
    )
}
