@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ApiKey authentication gives a name and a value that can be included in either the request header or query parameters.
 * @property in The location of the authentication key/value pair in the request.
 * @property name The key name of the authentication key/value pair.
 * @property type The authentication type.
 * Expected value is 'ApiKey'.
 * @property value The value of the authentication key/value pair.
 */
public data class ApiKeyAuthenticationResponse(
    public val `in`: String,
    public val name: String,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.ApiKeyAuthenticationResponse):
            ApiKeyAuthenticationResponse = ApiKeyAuthenticationResponse(
            `in` = javaType.`in`(),
            name = javaType.name(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
