@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Detailed error information of any failure.
 * @property code Error code string.
 * @property details More detailed error information.
 * @property message Descriptive error information.
 * @property target Error target
 */
public data class CloudErrorBodyResponse(
    public val code: String,
    public val details: List<CloudErrorBodyResponse>? = null,
    public val message: String,
    public val target: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.CloudErrorBodyResponse):
            CloudErrorBodyResponse = CloudErrorBodyResponse(
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.CloudErrorBodyResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
