@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The resource that defines the source location where the artifacts are located.
 * @property artifactRoot The path from the location that the 'authentication' property [say, a SAS URI to the blob container] refers to, to the location of the artifacts. This can be used to differentiate different versions of the artifacts. Or, different types of artifacts like binaries or templates. The location referenced by the authentication property concatenated with this optional artifactRoot path forms the artifact source location where the artifacts are expected to be found.
 * @property authentication The authentication method to use to access the artifact source.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property sourceType The type of artifact source used.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetArtifactSourceResult(
    public val artifactRoot: String? = null,
    public val authentication: SasAuthenticationResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val sourceType: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.GetArtifactSourceResult):
            GetArtifactSourceResult = GetArtifactSourceResult(
            artifactRoot = javaType.artifactRoot().map({ args0 -> args0 }).orElse(null),
            authentication = javaType.authentication().let({ args0 ->
                com.pulumi.azurenative.deploymentmanager.kotlin.outputs.SasAuthenticationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            sourceType = javaType.sourceType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
