@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the rollout.
 * @property artifactSourceId The reference to the artifact source resource Id where the payload is located.
 * @property buildVersion The version of the build being deployed.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity for the resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property operationInfo Operational information of the rollout.
 * @property services The detailed information on the services being deployed.
 * @property status The current status of the rollout.
 * @property stepGroups The list of step groups that define the orchestration.
 * @property tags Resource tags.
 * @property targetServiceTopologyId The resource Id of the service topology from which service units are being referenced in step groups to be deployed.
 * @property totalRetryAttempts The cardinal count of total number of retries performed on the rollout at a given time.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetRolloutResult(
    public val artifactSourceId: String? = null,
    public val buildVersion: String,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val operationInfo: RolloutOperationInfoResponse,
    public val services: List<ServiceResponse>,
    public val status: String,
    public val stepGroups: List<StepGroupResponse>,
    public val tags: Map<String, String>? = null,
    public val targetServiceTopologyId: String,
    public val totalRetryAttempts: Int,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.GetRolloutResult):
            GetRolloutResult = GetRolloutResult(
            artifactSourceId = javaType.artifactSourceId().map({ args0 -> args0 }).orElse(null),
            buildVersion = javaType.buildVersion(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            operationInfo = javaType.operationInfo().let({ args0 ->
                com.pulumi.azurenative.deploymentmanager.kotlin.outputs.RolloutOperationInfoResponse.Companion.toKotlin(args0)
            }),
            services = javaType.services().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.ServiceResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            stepGroups = javaType.stepGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.StepGroupResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetServiceTopologyId = javaType.targetServiceTopologyId(),
            totalRetryAttempts = javaType.totalRetryAttempts(),
            type = javaType.type(),
        )
    }
}
