@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The resource representation of a service in a service topology.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property tags Resource tags.
 * @property targetLocation The Azure location to which the resources in the service belong to or should be deployed to.
 * @property targetSubscriptionId The subscription to which the resources in the service belong to or should be deployed to.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetServiceResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val targetLocation: String,
    public val targetSubscriptionId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.GetServiceResult):
            GetServiceResult = GetServiceResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetLocation = javaType.targetLocation(),
            targetSubscriptionId = javaType.targetSubscriptionId(),
            type = javaType.type(),
        )
    }
}
