@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents the response of a service unit resource.
 * @property artifacts The artifacts for the service unit.
 * @property deploymentMode Describes the type of ARM deployment to be performed on the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property tags Resource tags.
 * @property targetResourceGroup The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetServiceUnitResult(
    public val artifacts: ServiceUnitArtifactsResponse? = null,
    public val deploymentMode: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroup: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.GetServiceUnitResult):
            GetServiceUnitResult = GetServiceUnitResult(
            artifacts = javaType.artifacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.ServiceUnitArtifactsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentMode = javaType.deploymentMode(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroup = javaType.targetResourceGroup(),
            type = javaType.type(),
        )
    }
}
