@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the properties of a health check step.
 * @property attributes The health check step attributes
 * @property stepType The type of step.
 * Expected value is 'HealthCheck'.
 */
public data class HealthCheckStepPropertiesResponse(
    public val attributes: RestHealthCheckStepAttributesResponse,
    public val stepType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.HealthCheckStepPropertiesResponse):
            HealthCheckStepPropertiesResponse = HealthCheckStepPropertiesResponse(
            attributes = javaType.attributes().let({ args0 ->
                com.pulumi.azurenative.deploymentmanager.kotlin.outputs.RestHealthCheckStepAttributesResponse.Companion.toKotlin(args0)
            }),
            stepType = javaType.stepType(),
        )
    }
}
