@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Identity for the resource.
 * @property identityIds The list of identities.
 * @property type The identity type.
 */
public data class IdentityResponse(
    public val identityIds: List<String>,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.IdentityResponse):
            IdentityResponse = IdentityResponse(
            identityIds = javaType.identityIds().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
