@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Supplementary contextual messages during a rollout.
 * @property message The actual message text.
 * @property timeStamp Time in UTC this message was provided.
 */
public data class MessageResponse(
    public val message: String,
    public val timeStamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.MessageResponse):
            MessageResponse = MessageResponse(
            message = javaType.message(),
            timeStamp = javaType.timeStamp(),
        )
    }
}
