@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Individual resource operation information.
 * @property operationId Unique identifier of the operation. For ARM resources, this is the operationId obtained from ARM service.
 * @property provisioningState State of the resource deployment. For ARM resources, this is the current provisioning state of the resource.
 * @property resourceName Name of the resource as specified in the artifacts. For ARM resources, this is the name of the resource specified in the template.
 * @property resourceType Type of the resource as specified in the artifacts. For ARM resources, this is the type of the resource specified in the template.
 * @property statusCode Http status code of the operation.
 * @property statusMessage Descriptive information of the resource operation.
 */
public data class ResourceOperationResponse(
    public val operationId: String,
    public val provisioningState: String,
    public val resourceName: String? = null,
    public val resourceType: String? = null,
    public val statusCode: String,
    public val statusMessage: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.ResourceOperationResponse):
            ResourceOperationResponse = ResourceOperationResponse(
            operationId = javaType.operationId(),
            provisioningState = javaType.provisioningState(),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            statusCode = javaType.statusCode(),
            statusMessage = javaType.statusMessage(),
        )
    }
}
