@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A REST based health check
 * @property name A unique name for this check.
 * @property request The request to the health provider.
 * @property response The expected response from the health provider. If no expected response is provided, the default is to expect the received response to have an HTTP status code of 200 OK.
 */
public data class RestHealthCheckResponse(
    public val name: String,
    public val request: RestRequestResponse,
    public val response: RestResponseResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.RestHealthCheckResponse):
            RestHealthCheckResponse = RestHealthCheckResponse(
            name = javaType.name(),
            request = javaType.request().let({ args0 ->
                com.pulumi.azurenative.deploymentmanager.kotlin.outputs.RestRequestResponse.Companion.toKotlin(args0)
            }),
            response = javaType.response().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.RestResponseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
