@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the REST health check step properties.
 * @property healthChecks The list of checks that form the health check step.
 * @property healthyStateDuration The duration in ISO 8601 format for which the resource is expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration is enforced after the detection of first healthy signal.
 * @property maxElasticDuration The duration in ISO 8601 format for which the health check waits for the resource to become healthy. Health check fails if it doesn't. Health check starts to enforce healthyStateDuration once resource becomes healthy.
 * @property type The type of health check.
 * Expected value is 'REST'.
 * @property waitDuration The duration in ISO 8601 format for which health check waits idly without any checks.
 */
public data class RestHealthCheckStepAttributesResponse(
    public val healthChecks: List<RestHealthCheckResponse>,
    public val healthyStateDuration: String,
    public val maxElasticDuration: String? = null,
    public val type: String,
    public val waitDuration: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.RestHealthCheckStepAttributesResponse):
            RestHealthCheckStepAttributesResponse = RestHealthCheckStepAttributesResponse(
            healthChecks = javaType.healthChecks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.RestHealthCheckResponse.Companion.toKotlin(args0)
                })
            }),
            healthyStateDuration = javaType.healthyStateDuration(),
            maxElasticDuration = javaType.maxElasticDuration().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            waitDuration = javaType.waitDuration().map({ args0 -> args0 }).orElse(null),
        )
    }
}
