@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * The properties that make up a REST request
 * @property authentication The authentication information required in the request to the health provider.
 * @property method The HTTP method to use for the request.
 * @property uri The HTTP URI to use for the request.
 */
public data class RestRequestResponse(
    public val authentication:
    Either<ApiKeyAuthenticationResponse, RolloutIdentityAuthenticationResponse>,
    public val method: String,
    public val uri: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.RestRequestResponse):
            RestRequestResponse = RestRequestResponse(
            authentication = javaType.authentication().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.deploymentmanager.kotlin.outputs.ApiKeyAuthenticationResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.deploymentmanager.kotlin.outputs.RolloutIdentityAuthenticationResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            method = javaType.method(),
            uri = javaType.uri(),
        )
    }
}
