@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties that make up the expected REST response
 * @property regex The regular expressions to match the response content with.
 * @property successStatusCodes The HTTP status codes expected in a successful health check response. The response is expected to match one of the given status codes. If no expected status codes are provided, default expected status code is 200 OK.
 */
public data class RestResponseResponse(
    public val regex: RestResponseResponseRegex? = null,
    public val successStatusCodes: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.RestResponseResponse):
            RestResponseResponse = RestResponseResponse(
            regex = javaType.regex().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.RestResponseResponseRegex.Companion.toKotlin(args0)
                })
            }).orElse(null),
            successStatusCodes = javaType.successStatusCodes().map({ args0 -> args0 }),
        )
    }
}
