@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The regular expressions to match the response content with.
 * @property matchQuantifier Indicates whether any or all of the expressions should match with the response content.
 * @property matches The list of regular expressions.
 */
public data class RestResponseResponseRegex(
    public val matchQuantifier: String? = null,
    public val matches: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.RestResponseResponseRegex):
            RestResponseResponseRegex = RestResponseResponseRegex(
            matchQuantifier = javaType.matchQuantifier().map({ args0 -> args0 }).orElse(null),
            matches = javaType.matches().map({ args0 -> args0 }),
        )
    }
}
