@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Detailed runtime information of the rollout.
 * @property endTime The start time of the rollout in UTC. This property will not be set if the rollout has not completed yet.
 * @property error The detailed error information for any failure.
 * @property retryAttempt The ordinal count of the number of retry attempts on a rollout. 0 if no retries of the rollout have been performed. If the rollout is updated with a PUT, this count is reset to 0.
 * @property skipSucceededOnRetry True, if all steps that succeeded on the previous run/attempt were chosen to be skipped in this retry attempt. False, otherwise.
 * @property startTime The start time of the rollout in UTC.
 */
public data class RolloutOperationInfoResponse(
    public val endTime: String,
    public val error: CloudErrorBodyResponse,
    public val retryAttempt: Int,
    public val skipSucceededOnRetry: Boolean,
    public val startTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.RolloutOperationInfoResponse):
            RolloutOperationInfoResponse = RolloutOperationInfoResponse(
            endTime = javaType.endTime(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.deploymentmanager.kotlin.outputs.CloudErrorBodyResponse.Companion.toKotlin(args0)
            }),
            retryAttempt = javaType.retryAttempt(),
            skipSucceededOnRetry = javaType.skipSucceededOnRetry(),
            startTime = javaType.startTime(),
        )
    }
}
