@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a specific step on a target service unit.
 * @property messages Supplementary informative messages during rollout.
 * @property name Name of the step.
 * @property operationInfo Detailed information of specific action execution.
 * @property resourceOperations Set of resource operations that were performed, if any, on an Azure resource.
 * @property status Current state of the step.
 * @property stepGroup The step group the current step is part of.
 */
public data class RolloutStepResponse(
    public val messages: List<MessageResponse>,
    public val name: String,
    public val operationInfo: StepOperationInfoResponse,
    public val resourceOperations: List<ResourceOperationResponse>,
    public val status: String,
    public val stepGroup: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.RolloutStepResponse):
            RolloutStepResponse = RolloutStepResponse(
            messages = javaType.messages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.MessageResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            operationInfo = javaType.operationInfo().let({ args0 ->
                com.pulumi.azurenative.deploymentmanager.kotlin.outputs.StepOperationInfoResponse.Companion.toKotlin(args0)
            }),
            resourceOperations = javaType.resourceOperations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.ResourceOperationResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            stepGroup = javaType.stepGroup().map({ args0 -> args0 }).orElse(null),
        )
    }
}
