@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the properties to access the artifacts using an Azure Storage SAS URI.
 * @property sasUri The SAS URI to the Azure Storage blob container. Any offset from the root of the container to where the artifacts are located can be defined in the artifactRoot.
 * @property type The authentication type
 * Expected value is 'Sas'.
 */
public data class SasAuthenticationResponse(
    public val sasUri: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.SasAuthenticationResponse):
            SasAuthenticationResponse = SasAuthenticationResponse(
            sasUri = javaType.sasUri(),
            type = javaType.type(),
        )
    }
}
