@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a service.
 * @property name Name of the service.
 * @property serviceUnits The detailed information about the units that make up the service.
 * @property targetLocation The Azure location to which the resources in the service belong to or should be deployed to.
 * @property targetSubscriptionId The subscription to which the resources in the service belong to or should be deployed to.
 */
public data class ServiceResponse(
    public val name: String? = null,
    public val serviceUnits: List<ServiceUnitResponse>? = null,
    public val targetLocation: String,
    public val targetSubscriptionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.ServiceResponse):
            ServiceResponse = ServiceResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            serviceUnits = javaType.serviceUnits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.ServiceUnitResponse.Companion.toKotlin(args0)
                })
            }),
            targetLocation = javaType.targetLocation(),
            targetSubscriptionId = javaType.targetSubscriptionId(),
        )
    }
}
