@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the artifacts of a service unit.
 * @property parametersArtifactSourceRelativePath The path to the ARM parameters file relative to the artifact source.
 * @property parametersUri The full URI of the ARM parameters file with the SAS token.
 * @property templateArtifactSourceRelativePath The path to the ARM template file relative to the artifact source.
 * @property templateUri The full URI of the ARM template file with the SAS token.
 */
public data class ServiceUnitArtifactsResponse(
    public val parametersArtifactSourceRelativePath: String? = null,
    public val parametersUri: String? = null,
    public val templateArtifactSourceRelativePath: String? = null,
    public val templateUri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.ServiceUnitArtifactsResponse):
            ServiceUnitArtifactsResponse = ServiceUnitArtifactsResponse(
            parametersArtifactSourceRelativePath = javaType.parametersArtifactSourceRelativePath().map({ args0 ->
                args0
            }).orElse(null),
            parametersUri = javaType.parametersUri().map({ args0 -> args0 }).orElse(null),
            templateArtifactSourceRelativePath = javaType.templateArtifactSourceRelativePath().map({ args0 ->
                args0
            }).orElse(null),
            templateUri = javaType.templateUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
