@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a service unit.
 * @property artifacts The artifacts for the service unit.
 * @property deploymentMode Describes the type of ARM deployment to be performed on the resource.
 * @property name Name of the service unit.
 * @property steps Detailed step information, if present.
 * @property targetResourceGroup The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
 */
public data class ServiceUnitResponse(
    public val artifacts: ServiceUnitArtifactsResponse? = null,
    public val deploymentMode: String,
    public val name: String? = null,
    public val steps: List<RolloutStepResponse>? = null,
    public val targetResourceGroup: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.ServiceUnitResponse):
            ServiceUnitResponse = ServiceUnitResponse(
            artifacts = javaType.artifacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.ServiceUnitArtifactsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentMode = javaType.deploymentMode(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            steps = javaType.steps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.RolloutStepResponse.Companion.toKotlin(args0)
                })
            }),
            targetResourceGroup = javaType.targetResourceGroup(),
        )
    }
}
