@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties that define a Step group in a rollout.
 * @property dependsOnStepGroups The list of step group names on which this step group depends on.
 * @property deploymentTargetId The resource Id of service unit to be deployed. The service unit should be from the service topology referenced in targetServiceTopologyId
 * @property name The name of the step group.
 * @property postDeploymentSteps The list of steps to be run after deploying the target.
 * @property preDeploymentSteps The list of steps to be run before deploying the target.
 */
public data class StepGroupResponse(
    public val dependsOnStepGroups: List<String>? = null,
    public val deploymentTargetId: String,
    public val name: String,
    public val postDeploymentSteps: List<PrePostStepResponse>? = null,
    public val preDeploymentSteps: List<PrePostStepResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.StepGroupResponse):
            StepGroupResponse = StepGroupResponse(
            dependsOnStepGroups = javaType.dependsOnStepGroups().map({ args0 -> args0 }),
            deploymentTargetId = javaType.deploymentTargetId(),
            name = javaType.name(),
            postDeploymentSteps = javaType.postDeploymentSteps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.PrePostStepResponse.Companion.toKotlin(args0)
                })
            }),
            preDeploymentSteps = javaType.preDeploymentSteps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.PrePostStepResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
