@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Detailed information of a specific step run.
 * @property correlationId Unique identifier to track the request for ARM-based resources.
 * @property deploymentName The name of the ARM deployment initiated as part of the step.
 * @property endTime End time of the action in UTC.
 * @property error The errors, if any, for the action.
 * @property lastUpdatedTime Last time in UTC this operation was updated.
 * @property startTime Start time of the action in UTC.
 */
public data class StepOperationInfoResponse(
    public val correlationId: String,
    public val deploymentName: String,
    public val endTime: String,
    public val error: CloudErrorBodyResponse? = null,
    public val lastUpdatedTime: String,
    public val startTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.StepOperationInfoResponse):
            StepOperationInfoResponse = StepOperationInfoResponse(
            correlationId = javaType.correlationId(),
            deploymentName = javaType.deploymentName(),
            endTime = javaType.endTime(),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deploymentmanager.kotlin.outputs.CloudErrorBodyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            startTime = javaType.startTime(),
        )
    }
}
