@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the properties of a Wait step.
 * @property attributes The Wait attributes
 * @property stepType The type of step.
 * Expected value is 'Wait'.
 */
public data class WaitStepPropertiesResponse(
    public val attributes: WaitStepAttributesResponse,
    public val stepType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deploymentmanager.outputs.WaitStepPropertiesResponse):
            WaitStepPropertiesResponse = WaitStepPropertiesResponse(
            attributes = javaType.attributes().let({ args0 ->
                com.pulumi.azurenative.deploymentmanager.kotlin.outputs.WaitStepAttributesResponse.Companion.toKotlin(args0)
            }),
            stepType = javaType.stepType(),
        )
    }
}
