@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.DayOfWeek
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SessionHandlingOperation
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SetStartVMOnConnect
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.StartupBehavior
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.TimeArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.TimeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a ScalingPlanPersonalSchedule definition.
 * Azure REST API version: 2023-07-07-preview.
 * Other available API versions: 2023-09-05, 2023-10-04-preview.
 * ## Example Usage
 * ### ScalingPlanPersonalSchedules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scalingPlanPersonalSchedule = new AzureNative.DesktopVirtualization.ScalingPlanPersonalSchedule("scalingPlanPersonalSchedule", new()
 *     {
 *         DaysOfWeek = new[]
 *         {
 *             "Monday",
 *             "Tuesday",
 *             "Wednesday",
 *             "Thursday",
 *             "Friday",
 *         },
 *         OffPeakActionOnDisconnect = "None",
 *         OffPeakActionOnLogoff = "Deallocate",
 *         OffPeakMinutesToWaitOnDisconnect = 10,
 *         OffPeakMinutesToWaitOnLogoff = 10,
 *         OffPeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 20,
 *             Minute = 0,
 *         },
 *         OffPeakStartVMOnConnect = "Enable",
 *         PeakActionOnDisconnect = "None",
 *         PeakActionOnLogoff = "Deallocate",
 *         PeakMinutesToWaitOnDisconnect = 10,
 *         PeakMinutesToWaitOnLogoff = 10,
 *         PeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 8,
 *             Minute = 0,
 *         },
 *         PeakStartVMOnConnect = "Enable",
 *         RampDownActionOnDisconnect = "None",
 *         RampDownActionOnLogoff = "Deallocate",
 *         RampDownMinutesToWaitOnDisconnect = 10,
 *         RampDownMinutesToWaitOnLogoff = 10,
 *         RampDownStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 18,
 *             Minute = 0,
 *         },
 *         RampDownStartVMOnConnect = "Enable",
 *         RampUpActionOnDisconnect = "None",
 *         RampUpActionOnLogoff = "None",
 *         RampUpAutoStartHosts = "All",
 *         RampUpMinutesToWaitOnDisconnect = 10,
 *         RampUpMinutesToWaitOnLogoff = 10,
 *         RampUpStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 6,
 *             Minute = 0,
 *         },
 *         RampUpStartVMOnConnect = "Enable",
 *         ResourceGroupName = "resourceGroup1",
 *         ScalingPlanName = "scalingPlan1",
 *         ScalingPlanScheduleName = "scalingPlanScheduleWeekdays1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewScalingPlanPersonalSchedule(ctx, "scalingPlanPersonalSchedule", &desktopvirtualization.ScalingPlanPersonalScheduleArgs{
 * 			DaysOfWeek: pulumi.StringArray{
 * 				pulumi.String("Monday"),
 * 				pulumi.String("Tuesday"),
 * 				pulumi.String("Wednesday"),
 * 				pulumi.String("Thursday"),
 * 				pulumi.String("Friday"),
 * 			},
 * 			OffPeakActionOnDisconnect:        pulumi.String("None"),
 * 			OffPeakActionOnLogoff:            pulumi.String("Deallocate"),
 * 			OffPeakMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			OffPeakMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			OffPeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(20),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			OffPeakStartVMOnConnect:       pulumi.String("Enable"),
 * 			PeakActionOnDisconnect:        pulumi.String("None"),
 * 			PeakActionOnLogoff:            pulumi.String("Deallocate"),
 * 			PeakMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			PeakMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			PeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(8),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			PeakStartVMOnConnect:              pulumi.String("Enable"),
 * 			RampDownActionOnDisconnect:        pulumi.String("None"),
 * 			RampDownActionOnLogoff:            pulumi.String("Deallocate"),
 * 			RampDownMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			RampDownMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			RampDownStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(18),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampDownStartVMOnConnect:        pulumi.String("Enable"),
 * 			RampUpActionOnDisconnect:        pulumi.String("None"),
 * 			RampUpActionOnLogoff:            pulumi.String("None"),
 * 			RampUpAutoStartHosts:            pulumi.String("All"),
 * 			RampUpMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			RampUpMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			RampUpStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(6),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampUpStartVMOnConnect:  pulumi.String("Enable"),
 * 			ResourceGroupName:       pulumi.String("resourceGroup1"),
 * 			ScalingPlanName:         pulumi.String("scalingPlan1"),
 * 			ScalingPlanScheduleName: pulumi.String("scalingPlanScheduleWeekdays1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalSchedule;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scalingPlanPersonalSchedule = new ScalingPlanPersonalSchedule("scalingPlanPersonalSchedule", ScalingPlanPersonalScheduleArgs.builder()
 *             .daysOfWeek(
 *                 "Monday",
 *                 "Tuesday",
 *                 "Wednesday",
 *                 "Thursday",
 *                 "Friday")
 *             .offPeakActionOnDisconnect("None")
 *             .offPeakActionOnLogoff("Deallocate")
 *             .offPeakMinutesToWaitOnDisconnect(10)
 *             .offPeakMinutesToWaitOnLogoff(10)
 *             .offPeakStartTime(Map.ofEntries(
 *                 Map.entry("hour", 20),
 *                 Map.entry("minute", 0)
 *             ))
 *             .offPeakStartVMOnConnect("Enable")
 *             .peakActionOnDisconnect("None")
 *             .peakActionOnLogoff("Deallocate")
 *             .peakMinutesToWaitOnDisconnect(10)
 *             .peakMinutesToWaitOnLogoff(10)
 *             .peakStartTime(Map.ofEntries(
 *                 Map.entry("hour", 8),
 *                 Map.entry("minute", 0)
 *             ))
 *             .peakStartVMOnConnect("Enable")
 *             .rampDownActionOnDisconnect("None")
 *             .rampDownActionOnLogoff("Deallocate")
 *             .rampDownMinutesToWaitOnDisconnect(10)
 *             .rampDownMinutesToWaitOnLogoff(10)
 *             .rampDownStartTime(Map.ofEntries(
 *                 Map.entry("hour", 18),
 *                 Map.entry("minute", 0)
 *             ))
 *             .rampDownStartVMOnConnect("Enable")
 *             .rampUpActionOnDisconnect("None")
 *             .rampUpActionOnLogoff("None")
 *             .rampUpAutoStartHosts("All")
 *             .rampUpMinutesToWaitOnDisconnect(10)
 *             .rampUpMinutesToWaitOnLogoff(10)
 *             .rampUpStartTime(Map.ofEntries(
 *                 Map.entry("hour", 6),
 *                 Map.entry("minute", 0)
 *             ))
 *             .rampUpStartVMOnConnect("Enable")
 *             .resourceGroupName("resourceGroup1")
 *             .scalingPlanName("scalingPlan1")
 *             .scalingPlanScheduleName("scalingPlanScheduleWeekdays1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:ScalingPlanPersonalSchedule scalingPlanScheduleWeekdays1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/personalSchedules/{scalingPlanScheduleName}
 * ```
 * @property daysOfWeek Set of days of the week on which this schedule is active.
 * @property offPeakActionOnDisconnect Action to be taken after a user disconnect during the off-peak period.
 * @property offPeakActionOnLogoff Action to be taken after a logoff during the off-peak period.
 * @property offPeakMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak period.
 * @property offPeakMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak period.
 * @property offPeakStartTime Starting time for off-peak period.
 * @property offPeakStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
 * @property peakActionOnDisconnect Action to be taken after a user disconnect during the peak period.
 * @property peakActionOnLogoff Action to be taken after a logoff during the peak period.
 * @property peakMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak period.
 * @property peakMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the peak period.
 * @property peakStartTime Starting time for peak period.
 * @property peakStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the peak phase.
 * @property rampDownActionOnDisconnect Action to be taken after a user disconnect during the ramp down period.
 * @property rampDownActionOnLogoff Action to be taken after a logoff during the ramp down period.
 * @property rampDownMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp down period.
 * @property rampDownMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp down period.
 * @property rampDownStartTime Starting time for ramp down period.
 * @property rampDownStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
 * @property rampUpActionOnDisconnect Action to be taken after a user disconnect during the ramp up period.
 * @property rampUpActionOnLogoff Action to be taken after a logoff during the ramp up period.
 * @property rampUpAutoStartHosts The desired startup behavior during the ramp up period for personal vms in the hostpool.
 * @property rampUpMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp up period.
 * @property rampUpMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp up period.
 * @property rampUpStartTime Starting time for ramp up period.
 * @property rampUpStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingPlanName The name of the scaling plan.
 * @property scalingPlanScheduleName The name of the ScalingPlanSchedule
 */
public data class ScalingPlanPersonalScheduleArgs(
    public val daysOfWeek: Output<List<Either<String, DayOfWeek>>>? = null,
    public val offPeakActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null,
    public val offPeakActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null,
    public val offPeakMinutesToWaitOnDisconnect: Output<Int>? = null,
    public val offPeakMinutesToWaitOnLogoff: Output<Int>? = null,
    public val offPeakStartTime: Output<TimeArgs>? = null,
    public val offPeakStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null,
    public val peakActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null,
    public val peakActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null,
    public val peakMinutesToWaitOnDisconnect: Output<Int>? = null,
    public val peakMinutesToWaitOnLogoff: Output<Int>? = null,
    public val peakStartTime: Output<TimeArgs>? = null,
    public val peakStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null,
    public val rampDownActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null,
    public val rampDownActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null,
    public val rampDownMinutesToWaitOnDisconnect: Output<Int>? = null,
    public val rampDownMinutesToWaitOnLogoff: Output<Int>? = null,
    public val rampDownStartTime: Output<TimeArgs>? = null,
    public val rampDownStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null,
    public val rampUpActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null,
    public val rampUpActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null,
    public val rampUpAutoStartHosts: Output<Either<String, StartupBehavior>>? = null,
    public val rampUpMinutesToWaitOnDisconnect: Output<Int>? = null,
    public val rampUpMinutesToWaitOnLogoff: Output<Int>? = null,
    public val rampUpStartTime: Output<TimeArgs>? = null,
    public val rampUpStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalingPlanName: Output<String>? = null,
    public val scalingPlanScheduleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs =
        com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs.builder()
            .daysOfWeek(
                daysOfWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .offPeakActionOnDisconnect(
                offPeakActionOnDisconnect?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .offPeakActionOnLogoff(
                offPeakActionOnLogoff?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .offPeakMinutesToWaitOnDisconnect(offPeakMinutesToWaitOnDisconnect?.applyValue({ args0 -> args0 }))
            .offPeakMinutesToWaitOnLogoff(offPeakMinutesToWaitOnLogoff?.applyValue({ args0 -> args0 }))
            .offPeakStartTime(offPeakStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .offPeakStartVMOnConnect(
                offPeakStartVMOnConnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .peakActionOnDisconnect(
                peakActionOnDisconnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .peakActionOnLogoff(
                peakActionOnLogoff?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .peakMinutesToWaitOnDisconnect(peakMinutesToWaitOnDisconnect?.applyValue({ args0 -> args0 }))
            .peakMinutesToWaitOnLogoff(peakMinutesToWaitOnLogoff?.applyValue({ args0 -> args0 }))
            .peakStartTime(peakStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .peakStartVMOnConnect(
                peakStartVMOnConnect?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .rampDownActionOnDisconnect(
                rampDownActionOnDisconnect?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampDownActionOnLogoff(
                rampDownActionOnLogoff?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampDownMinutesToWaitOnDisconnect(
                rampDownMinutesToWaitOnDisconnect?.applyValue({ args0 ->
                    args0
                }),
            )
            .rampDownMinutesToWaitOnLogoff(rampDownMinutesToWaitOnLogoff?.applyValue({ args0 -> args0 }))
            .rampDownStartTime(rampDownStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rampDownStartVMOnConnect(
                rampDownStartVMOnConnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampUpActionOnDisconnect(
                rampUpActionOnDisconnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampUpActionOnLogoff(
                rampUpActionOnLogoff?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .rampUpAutoStartHosts(
                rampUpAutoStartHosts?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .rampUpMinutesToWaitOnDisconnect(rampUpMinutesToWaitOnDisconnect?.applyValue({ args0 -> args0 }))
            .rampUpMinutesToWaitOnLogoff(rampUpMinutesToWaitOnLogoff?.applyValue({ args0 -> args0 }))
            .rampUpStartTime(rampUpStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rampUpStartVMOnConnect(
                rampUpStartVMOnConnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalingPlanName(scalingPlanName?.applyValue({ args0 -> args0 }))
            .scalingPlanScheduleName(scalingPlanScheduleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingPlanPersonalScheduleArgs].
 */
@PulumiTagMarker
public class ScalingPlanPersonalScheduleArgsBuilder internal constructor() {
    private var daysOfWeek: Output<List<Either<String, DayOfWeek>>>? = null

    private var offPeakActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null

    private var offPeakActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null

    private var offPeakMinutesToWaitOnDisconnect: Output<Int>? = null

    private var offPeakMinutesToWaitOnLogoff: Output<Int>? = null

    private var offPeakStartTime: Output<TimeArgs>? = null

    private var offPeakStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null

    private var peakActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null

    private var peakActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null

    private var peakMinutesToWaitOnDisconnect: Output<Int>? = null

    private var peakMinutesToWaitOnLogoff: Output<Int>? = null

    private var peakStartTime: Output<TimeArgs>? = null

    private var peakStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null

    private var rampDownActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null

    private var rampDownActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null

    private var rampDownMinutesToWaitOnDisconnect: Output<Int>? = null

    private var rampDownMinutesToWaitOnLogoff: Output<Int>? = null

    private var rampDownStartTime: Output<TimeArgs>? = null

    private var rampDownStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null

    private var rampUpActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null

    private var rampUpActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null

    private var rampUpAutoStartHosts: Output<Either<String, StartupBehavior>>? = null

    private var rampUpMinutesToWaitOnDisconnect: Output<Int>? = null

    private var rampUpMinutesToWaitOnLogoff: Output<Int>? = null

    private var rampUpStartTime: Output<TimeArgs>? = null

    private var rampUpStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalingPlanName: Output<String>? = null

    private var scalingPlanScheduleName: Output<String>? = null

    /**
     * @param value Set of days of the week on which this schedule is active.
     */
    @JvmName("kjyrvedlkucorepb")
    public suspend fun daysOfWeek(`value`: Output<List<Either<String, DayOfWeek>>>) {
        this.daysOfWeek = value
    }

    @JvmName("edcsymlocvtjghjk")
    public suspend fun daysOfWeek(vararg values: Output<Either<String, DayOfWeek>>) {
        this.daysOfWeek = Output.all(values.asList())
    }

    /**
     * @param values Set of days of the week on which this schedule is active.
     */
    @JvmName("xmojahxlqhyvisia")
    public suspend fun daysOfWeek(values: List<Output<Either<String, DayOfWeek>>>) {
        this.daysOfWeek = Output.all(values)
    }

    /**
     * @param value Action to be taken after a user disconnect during the off-peak period.
     */
    @JvmName("hjsjjkgdbfeildgp")
    public suspend
    fun offPeakActionOnDisconnect(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.offPeakActionOnDisconnect = value
    }

    /**
     * @param value Action to be taken after a logoff during the off-peak period.
     */
    @JvmName("jjlfeereapowtxuv")
    public suspend
    fun offPeakActionOnLogoff(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.offPeakActionOnLogoff = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak period.
     */
    @JvmName("nolelmmoghqtwawn")
    public suspend fun offPeakMinutesToWaitOnDisconnect(`value`: Output<Int>) {
        this.offPeakMinutesToWaitOnDisconnect = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak period.
     */
    @JvmName("oimmdvnqsuwdrxao")
    public suspend fun offPeakMinutesToWaitOnLogoff(`value`: Output<Int>) {
        this.offPeakMinutesToWaitOnLogoff = value
    }

    /**
     * @param value Starting time for off-peak period.
     */
    @JvmName("cupuppsweabioxsg")
    public suspend fun offPeakStartTime(`value`: Output<TimeArgs>) {
        this.offPeakStartTime = value
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    @JvmName("dmqyvxdmdqxujvtb")
    public suspend fun offPeakStartVMOnConnect(`value`: Output<Either<String, SetStartVMOnConnect>>) {
        this.offPeakStartVMOnConnect = value
    }

    /**
     * @param value Action to be taken after a user disconnect during the peak period.
     */
    @JvmName("skfgjnexxdlxowbi")
    public suspend
    fun peakActionOnDisconnect(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.peakActionOnDisconnect = value
    }

    /**
     * @param value Action to be taken after a logoff during the peak period.
     */
    @JvmName("kmmrxkfgxemamfag")
    public suspend fun peakActionOnLogoff(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.peakActionOnLogoff = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak period.
     */
    @JvmName("swkdaxjxixfpdklx")
    public suspend fun peakMinutesToWaitOnDisconnect(`value`: Output<Int>) {
        this.peakMinutesToWaitOnDisconnect = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the peak period.
     */
    @JvmName("vblxwilfdbdtibsj")
    public suspend fun peakMinutesToWaitOnLogoff(`value`: Output<Int>) {
        this.peakMinutesToWaitOnLogoff = value
    }

    /**
     * @param value Starting time for peak period.
     */
    @JvmName("bjviiqpbkyngayqo")
    public suspend fun peakStartTime(`value`: Output<TimeArgs>) {
        this.peakStartTime = value
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    @JvmName("wurwjrjmwquakuqe")
    public suspend fun peakStartVMOnConnect(`value`: Output<Either<String, SetStartVMOnConnect>>) {
        this.peakStartVMOnConnect = value
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp down period.
     */
    @JvmName("osrmewfelhexnmjs")
    public suspend
    fun rampDownActionOnDisconnect(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.rampDownActionOnDisconnect = value
    }

    /**
     * @param value Action to be taken after a logoff during the ramp down period.
     */
    @JvmName("hhcxcnpyowvwpome")
    public suspend
    fun rampDownActionOnLogoff(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.rampDownActionOnLogoff = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp down period.
     */
    @JvmName("udlqrcdgtcxgdrlg")
    public suspend fun rampDownMinutesToWaitOnDisconnect(`value`: Output<Int>) {
        this.rampDownMinutesToWaitOnDisconnect = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp down period.
     */
    @JvmName("soawyhgorqpunldk")
    public suspend fun rampDownMinutesToWaitOnLogoff(`value`: Output<Int>) {
        this.rampDownMinutesToWaitOnLogoff = value
    }

    /**
     * @param value Starting time for ramp down period.
     */
    @JvmName("wkkrvhfjbkywyoeo")
    public suspend fun rampDownStartTime(`value`: Output<TimeArgs>) {
        this.rampDownStartTime = value
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    @JvmName("gfcxmnchstosvjsa")
    public suspend
    fun rampDownStartVMOnConnect(`value`: Output<Either<String, SetStartVMOnConnect>>) {
        this.rampDownStartVMOnConnect = value
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp up period.
     */
    @JvmName("rildvglusvjwramg")
    public suspend
    fun rampUpActionOnDisconnect(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.rampUpActionOnDisconnect = value
    }

    /**
     * @param value Action to be taken after a logoff during the ramp up period.
     */
    @JvmName("xosmvywkysqfhavi")
    public suspend
    fun rampUpActionOnLogoff(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.rampUpActionOnLogoff = value
    }

    /**
     * @param value The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    @JvmName("ftuloexbplwwowwa")
    public suspend fun rampUpAutoStartHosts(`value`: Output<Either<String, StartupBehavior>>) {
        this.rampUpAutoStartHosts = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp up period.
     */
    @JvmName("wgklnnbqxndauyhk")
    public suspend fun rampUpMinutesToWaitOnDisconnect(`value`: Output<Int>) {
        this.rampUpMinutesToWaitOnDisconnect = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp up period.
     */
    @JvmName("fgxgevnmwdhjxhux")
    public suspend fun rampUpMinutesToWaitOnLogoff(`value`: Output<Int>) {
        this.rampUpMinutesToWaitOnLogoff = value
    }

    /**
     * @param value Starting time for ramp up period.
     */
    @JvmName("pyvrqqqdydwifnrp")
    public suspend fun rampUpStartTime(`value`: Output<TimeArgs>) {
        this.rampUpStartTime = value
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    @JvmName("ewlioxccwidyehel")
    public suspend fun rampUpStartVMOnConnect(`value`: Output<Either<String, SetStartVMOnConnect>>) {
        this.rampUpStartVMOnConnect = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xwhjqeyuepgnofun")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("qdvnaxvutwdiiaqa")
    public suspend fun scalingPlanName(`value`: Output<String>) {
        this.scalingPlanName = value
    }

    /**
     * @param value The name of the ScalingPlanSchedule
     */
    @JvmName("wkrnwbkkrnyjscna")
    public suspend fun scalingPlanScheduleName(`value`: Output<String>) {
        this.scalingPlanScheduleName = value
    }

    /**
     * @param value Set of days of the week on which this schedule is active.
     */
    @JvmName("xhvrpjxsfxqhkrik")
    public suspend fun daysOfWeek(`value`: List<Either<String, DayOfWeek>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param values Set of days of the week on which this schedule is active.
     */
    @JvmName("fnrbtthvugjqshhk")
    public suspend fun daysOfWeek(vararg values: Either<String, DayOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the off-peak period.
     */
    @JvmName("qwamshlsitsllfho")
    public suspend fun offPeakActionOnDisconnect(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the off-peak period.
     */
    @JvmName("yfgwaclejowwfoqu")
    public fun offPeakActionOnDisconnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the off-peak period.
     */
    @JvmName("cjansoeofmkxjird")
    public fun offPeakActionOnDisconnect(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the off-peak period.
     */
    @JvmName("bhhvvciqqwvuxdex")
    public suspend fun offPeakActionOnLogoff(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the off-peak period.
     */
    @JvmName("fqbrwupusermyrra")
    public fun offPeakActionOnLogoff(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the off-peak period.
     */
    @JvmName("tagxvwvvgrssfpgd")
    public fun offPeakActionOnLogoff(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakActionOnLogoff = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak period.
     */
    @JvmName("bgwdafkqcrnacjjf")
    public suspend fun offPeakMinutesToWaitOnDisconnect(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakMinutesToWaitOnDisconnect = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak period.
     */
    @JvmName("lpoclterhktdokhx")
    public suspend fun offPeakMinutesToWaitOnLogoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakMinutesToWaitOnLogoff = mapped
    }

    /**
     * @param value Starting time for off-peak period.
     */
    @JvmName("bxdivrqttbhvgdwj")
    public suspend fun offPeakStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakStartTime = mapped
    }

    /**
     * @param argument Starting time for off-peak period.
     */
    @JvmName("rdmxhmelgtijxwow")
    public suspend fun offPeakStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.offPeakStartTime = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    @JvmName("iejgkanavgrpuqnc")
    public suspend fun offPeakStartVMOnConnect(`value`: Either<String, SetStartVMOnConnect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    @JvmName("sikhwgoesivfwgvl")
    public fun offPeakStartVMOnConnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    @JvmName("knkqaymmtqrksonk")
    public fun offPeakStartVMOnConnect(`value`: SetStartVMOnConnect) {
        val toBeMapped = Either.ofRight<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakStartVMOnConnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the peak period.
     */
    @JvmName("lovflgacvotdokbo")
    public suspend fun peakActionOnDisconnect(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the peak period.
     */
    @JvmName("jwkvaytxhnajcjni")
    public fun peakActionOnDisconnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the peak period.
     */
    @JvmName("ftqmiivibraktvoa")
    public fun peakActionOnDisconnect(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the peak period.
     */
    @JvmName("hiuggpxxjjhtqajt")
    public suspend fun peakActionOnLogoff(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the peak period.
     */
    @JvmName("suainhshbgpxlsyi")
    public fun peakActionOnLogoff(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the peak period.
     */
    @JvmName("xtallsciqbmatynt")
    public fun peakActionOnLogoff(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakActionOnLogoff = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak period.
     */
    @JvmName("jikxhdkfetgyglfn")
    public suspend fun peakMinutesToWaitOnDisconnect(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakMinutesToWaitOnDisconnect = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the peak period.
     */
    @JvmName("hmabwlqxbonptcrk")
    public suspend fun peakMinutesToWaitOnLogoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakMinutesToWaitOnLogoff = mapped
    }

    /**
     * @param value Starting time for peak period.
     */
    @JvmName("watkmjiscgesaetm")
    public suspend fun peakStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakStartTime = mapped
    }

    /**
     * @param argument Starting time for peak period.
     */
    @JvmName("uyukhyscgseobtoa")
    public suspend fun peakStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peakStartTime = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    @JvmName("gdronwkfiwfdcxvs")
    public suspend fun peakStartVMOnConnect(`value`: Either<String, SetStartVMOnConnect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    @JvmName("cidyphxnhyxrrhtq")
    public fun peakStartVMOnConnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    @JvmName("abasgapelgjptbeb")
    public fun peakStartVMOnConnect(`value`: SetStartVMOnConnect) {
        val toBeMapped = Either.ofRight<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakStartVMOnConnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp down period.
     */
    @JvmName("tcjtvhxkpmmuxxuy")
    public suspend
    fun rampDownActionOnDisconnect(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp down period.
     */
    @JvmName("ibiurnajudnxevod")
    public fun rampDownActionOnDisconnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp down period.
     */
    @JvmName("mgukklimhkwnnjye")
    public fun rampDownActionOnDisconnect(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp down period.
     */
    @JvmName("xtqxwbwgxmrgabiv")
    public suspend fun rampDownActionOnLogoff(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp down period.
     */
    @JvmName("aeskvkyhadpgriha")
    public fun rampDownActionOnLogoff(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp down period.
     */
    @JvmName("tjjtawpyiawoxnnn")
    public fun rampDownActionOnLogoff(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownActionOnLogoff = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp down period.
     */
    @JvmName("ckmovwrbokodukxb")
    public suspend fun rampDownMinutesToWaitOnDisconnect(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownMinutesToWaitOnDisconnect = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp down period.
     */
    @JvmName("qxqkethrdrdlcndg")
    public suspend fun rampDownMinutesToWaitOnLogoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownMinutesToWaitOnLogoff = mapped
    }

    /**
     * @param value Starting time for ramp down period.
     */
    @JvmName("higlmmwnlxxjbcqw")
    public suspend fun rampDownStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownStartTime = mapped
    }

    /**
     * @param argument Starting time for ramp down period.
     */
    @JvmName("bfimsloyqhusaifq")
    public suspend fun rampDownStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rampDownStartTime = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    @JvmName("pfuhiwohhvylwxls")
    public suspend fun rampDownStartVMOnConnect(`value`: Either<String, SetStartVMOnConnect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    @JvmName("qkxcdflbxsnurdsh")
    public fun rampDownStartVMOnConnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    @JvmName("muknplvcnevrooye")
    public fun rampDownStartVMOnConnect(`value`: SetStartVMOnConnect) {
        val toBeMapped = Either.ofRight<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownStartVMOnConnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp up period.
     */
    @JvmName("kkgwqdssxvsbhtys")
    public suspend fun rampUpActionOnDisconnect(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp up period.
     */
    @JvmName("hmxdwqfbmgicbqlv")
    public fun rampUpActionOnDisconnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp up period.
     */
    @JvmName("pirtmoephjgtgpqf")
    public fun rampUpActionOnDisconnect(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp up period.
     */
    @JvmName("jkfkbkujcssuoogc")
    public suspend fun rampUpActionOnLogoff(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp up period.
     */
    @JvmName("vmmbqjmxsjuiltoq")
    public fun rampUpActionOnLogoff(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp up period.
     */
    @JvmName("foihbsowekslmkhf")
    public fun rampUpActionOnLogoff(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpActionOnLogoff = mapped
    }

    /**
     * @param value The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    @JvmName("diqtbbqprxhcdhlg")
    public suspend fun rampUpAutoStartHosts(`value`: Either<String, StartupBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpAutoStartHosts = mapped
    }

    /**
     * @param value The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    @JvmName("pjuaftbrejcxexkj")
    public fun rampUpAutoStartHosts(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StartupBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpAutoStartHosts = mapped
    }

    /**
     * @param value The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    @JvmName("nbtrfvlxahsmrysq")
    public fun rampUpAutoStartHosts(`value`: StartupBehavior) {
        val toBeMapped = Either.ofRight<String, StartupBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpAutoStartHosts = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp up period.
     */
    @JvmName("dqgimvesalkkefss")
    public suspend fun rampUpMinutesToWaitOnDisconnect(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpMinutesToWaitOnDisconnect = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp up period.
     */
    @JvmName("fjjqamcfjsckgxoq")
    public suspend fun rampUpMinutesToWaitOnLogoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpMinutesToWaitOnLogoff = mapped
    }

    /**
     * @param value Starting time for ramp up period.
     */
    @JvmName("tsmkwujnwygklotg")
    public suspend fun rampUpStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpStartTime = mapped
    }

    /**
     * @param argument Starting time for ramp up period.
     */
    @JvmName("wobudagjnxmpxrxn")
    public suspend fun rampUpStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rampUpStartTime = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    @JvmName("utysefeethdmiotx")
    public suspend fun rampUpStartVMOnConnect(`value`: Either<String, SetStartVMOnConnect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    @JvmName("hgvkxcnvsngeodtr")
    public fun rampUpStartVMOnConnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    @JvmName("moocifhkrxrscjva")
    public fun rampUpStartVMOnConnect(`value`: SetStartVMOnConnect) {
        val toBeMapped = Either.ofRight<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpStartVMOnConnect = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kfpuinvktktnnkkk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("jlbaomjfwlmfyabc")
    public suspend fun scalingPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPlanName = mapped
    }

    /**
     * @param value The name of the ScalingPlanSchedule
     */
    @JvmName("uynqdryqenjgggam")
    public suspend fun scalingPlanScheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPlanScheduleName = mapped
    }

    internal fun build(): ScalingPlanPersonalScheduleArgs = ScalingPlanPersonalScheduleArgs(
        daysOfWeek = daysOfWeek,
        offPeakActionOnDisconnect = offPeakActionOnDisconnect,
        offPeakActionOnLogoff = offPeakActionOnLogoff,
        offPeakMinutesToWaitOnDisconnect = offPeakMinutesToWaitOnDisconnect,
        offPeakMinutesToWaitOnLogoff = offPeakMinutesToWaitOnLogoff,
        offPeakStartTime = offPeakStartTime,
        offPeakStartVMOnConnect = offPeakStartVMOnConnect,
        peakActionOnDisconnect = peakActionOnDisconnect,
        peakActionOnLogoff = peakActionOnLogoff,
        peakMinutesToWaitOnDisconnect = peakMinutesToWaitOnDisconnect,
        peakMinutesToWaitOnLogoff = peakMinutesToWaitOnLogoff,
        peakStartTime = peakStartTime,
        peakStartVMOnConnect = peakStartVMOnConnect,
        rampDownActionOnDisconnect = rampDownActionOnDisconnect,
        rampDownActionOnLogoff = rampDownActionOnLogoff,
        rampDownMinutesToWaitOnDisconnect = rampDownMinutesToWaitOnDisconnect,
        rampDownMinutesToWaitOnLogoff = rampDownMinutesToWaitOnLogoff,
        rampDownStartTime = rampDownStartTime,
        rampDownStartVMOnConnect = rampDownStartVMOnConnect,
        rampUpActionOnDisconnect = rampUpActionOnDisconnect,
        rampUpActionOnLogoff = rampUpActionOnLogoff,
        rampUpAutoStartHosts = rampUpAutoStartHosts,
        rampUpMinutesToWaitOnDisconnect = rampUpMinutesToWaitOnDisconnect,
        rampUpMinutesToWaitOnLogoff = rampUpMinutesToWaitOnLogoff,
        rampUpStartTime = rampUpStartTime,
        rampUpStartVMOnConnect = rampUpStartVMOnConnect,
        resourceGroupName = resourceGroupName,
        scalingPlanName = scalingPlanName,
        scalingPlanScheduleName = scalingPlanScheduleName,
    )
}
