@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of preferred application group type, default to Desktop Application Group
 */
public enum class PreferredAppGroupType(
    public val javaValue: com.pulumi.azurenative.desktopvirtualization.enums.PreferredAppGroupType,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.enums.PreferredAppGroupType> {
    None(com.pulumi.azurenative.desktopvirtualization.enums.PreferredAppGroupType.None),
    Desktop(com.pulumi.azurenative.desktopvirtualization.enums.PreferredAppGroupType.Desktop),
    RailApplications(com.pulumi.azurenative.desktopvirtualization.enums.PreferredAppGroupType.RailApplications),
    ;

    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.enums.PreferredAppGroupType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.enums.PreferredAppGroupType):
            PreferredAppGroupType = PreferredAppGroupType.values().first { it.javaValue == javaType }
    }
}
