@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The time for a scaling action to occur.
 * @property hour The hour.
 * @property minute The minute.
 */
public data class TimeArgs(
    public val hour: Output<Int>,
    public val minute: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs.builder()
            .hour(hour.applyValue({ args0 -> args0 }))
            .minute(minute.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TimeArgs].
 */
@PulumiTagMarker
public class TimeArgsBuilder internal constructor() {
    private var hour: Output<Int>? = null

    private var minute: Output<Int>? = null

    /**
     * @param value The hour.
     */
    @JvmName("leaskkkejepqfxii")
    public suspend fun hour(`value`: Output<Int>) {
        this.hour = value
    }

    /**
     * @param value The minute.
     */
    @JvmName("gmnhxlcwlhjmddnj")
    public suspend fun minute(`value`: Output<Int>) {
        this.minute = value
    }

    /**
     * @param value The hour.
     */
    @JvmName("kvlouuyfqcsbtuua")
    public suspend fun hour(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hour = mapped
    }

    /**
     * @param value The minute.
     */
    @JvmName("gasbrpojcstoqimp")
    public suspend fun minute(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minute = mapped
    }

    internal fun build(): TimeArgs = TimeArgs(
        hour = hour ?: throw PulumiNullFieldException("hour"),
        minute = minute ?: throw PulumiNullFieldException("minute"),
    )
}
