@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Maintenance window starting hour and day of week.
 * @property dayOfWeek Day of the week.
 * @property hour The update start hour of the day. (0 - 23)
 */
public data class MaintenanceWindowPropertiesResponse(
    public val dayOfWeek: String? = null,
    public val hour: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.MaintenanceWindowPropertiesResponse):
            MaintenanceWindowPropertiesResponse = MaintenanceWindowPropertiesResponse(
            dayOfWeek = javaType.dayOfWeek().map({ args0 -> args0 }).orElse(null),
            hour = javaType.hour().map({ args0 -> args0 }).orElse(null),
        )
    }
}
