@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AttachedNetworkByDevCenter].
 */
@PulumiTagMarker
public class AttachedNetworkByDevCenterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AttachedNetworkByDevCenterArgs = AttachedNetworkByDevCenterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AttachedNetworkByDevCenterArgsBuilder.() -> Unit) {
        val builder = AttachedNetworkByDevCenterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AttachedNetworkByDevCenter {
        val builtJavaResource =
            com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AttachedNetworkByDevCenter(builtJavaResource)
    }
}

/**
 * Represents an attached NetworkConnection.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### AttachedNetworks_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attachedNetworkByDevCenter = new AzureNative.DevCenter.AttachedNetworkByDevCenter("attachedNetworkByDevCenter", new()
 *     {
 *         AttachedNetworkConnectionName = "network-uswest3",
 *         DevCenterName = "Contoso",
 *         NetworkConnectionId = "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/NetworkConnections/network-uswest3",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewAttachedNetworkByDevCenter(ctx, "attachedNetworkByDevCenter", &devcenter.AttachedNetworkByDevCenterArgs{
 * 			AttachedNetworkConnectionName: pulumi.String("network-uswest3"),
 * 			DevCenterName:                 pulumi.String("Contoso"),
 * 			NetworkConnectionId:           pulumi.String("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/NetworkConnections/network-uswest3"),
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenter;
 * import com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attachedNetworkByDevCenter = new AttachedNetworkByDevCenter("attachedNetworkByDevCenter", AttachedNetworkByDevCenterArgs.builder()
 *             .attachedNetworkConnectionName("network-uswest3")
 *             .devCenterName("Contoso")
 *             .networkConnectionId("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/NetworkConnections/network-uswest3")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:AttachedNetworkByDevCenter network-uswest3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/attachednetworks/{attachedNetworkConnectionName}
 * ```
 */
public class AttachedNetworkByDevCenter internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenter,
) : KotlinCustomResource(javaResource, AttachedNetworkByDevCenterMapper) {
    /**
     * AAD Join type of the network. This is populated based on the referenced Network Connection.
     */
    public val domainJoinType: Output<String>
        get() = javaResource.domainJoinType().applyValue({ args0 -> args0 })

    /**
     * Health check status values
     */
    public val healthCheckStatus: Output<String>
        get() = javaResource.healthCheckStatus().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the NetworkConnection you want to attach.
     */
    public val networkConnectionId: Output<String>
        get() = javaResource.networkConnectionId().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the NetworkConnection resource specified in 'networkConnectionResourceId' property lives.
     */
    public val networkConnectionLocation: Output<String>
        get() = javaResource.networkConnectionLocation().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AttachedNetworkByDevCenterMapper : ResourceMapper<AttachedNetworkByDevCenter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenter::class == javaResource::class

    override fun map(javaResource: Resource): AttachedNetworkByDevCenter =
        AttachedNetworkByDevCenter(
            javaResource as
                com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenter,
        )
}

/**
 * @see [AttachedNetworkByDevCenter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AttachedNetworkByDevCenter].
 */
public suspend fun attachedNetworkByDevCenter(
    name: String,
    block: suspend AttachedNetworkByDevCenterResourceBuilder.() -> Unit,
):
    AttachedNetworkByDevCenter {
    val builder = AttachedNetworkByDevCenterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AttachedNetworkByDevCenter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun attachedNetworkByDevCenter(name: String): AttachedNetworkByDevCenter {
    val builder = AttachedNetworkByDevCenterResourceBuilder()
    builder.name(name)
    return builder.build()
}
