@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.ImageReferenceResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.ImageValidationErrorDetailsResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devcenter.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin as imageReferenceResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.ImageValidationErrorDetailsResponse.Companion.toKotlin as imageValidationErrorDetailsResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DevBoxDefinition].
 */
@PulumiTagMarker
public class DevBoxDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevBoxDefinitionArgs = DevBoxDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevBoxDefinitionArgsBuilder.() -> Unit) {
        val builder = DevBoxDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DevBoxDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.devcenter.DevBoxDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DevBoxDefinition(builtJavaResource)
    }
}

/**
 * Represents a definition for a Developer Machine.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2022-11-11-preview, 2023-08-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### DevBoxDefinitions_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devBoxDefinition = new AzureNative.DevCenter.DevBoxDefinition("devBoxDefinition", new()
 *     {
 *         DevBoxDefinitionName = "WebDevBox",
 *         DevCenterName = "Contoso",
 *         HibernateSupport = "Enabled",
 *         ImageReference = new AzureNative.DevCenter.Inputs.ImageReferenceArgs
 *         {
 *             Id = "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/Example/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/contosogallery/images/exampleImage/version/1.0.0",
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.DevCenter.Inputs.SkuArgs
 *         {
 *             Name = "Preview",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewDevBoxDefinition(ctx, "devBoxDefinition", &devcenter.DevBoxDefinitionArgs{
 * 			DevBoxDefinitionName: pulumi.String("WebDevBox"),
 * 			DevCenterName:        pulumi.String("Contoso"),
 * 			HibernateSupport:     pulumi.String("Enabled"),
 * 			ImageReference: &devcenter.ImageReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/Example/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/contosogallery/images/exampleImage/version/1.0.0"),
 * 			},
 * 			Location:          pulumi.String("centralus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &devcenter.SkuArgs{
 * 				Name: pulumi.String("Preview"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.DevBoxDefinition;
 * import com.pulumi.azurenative.devcenter.DevBoxDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devBoxDefinition = new DevBoxDefinition("devBoxDefinition", DevBoxDefinitionArgs.builder()
 *             .devBoxDefinitionName("WebDevBox")
 *             .devCenterName("Contoso")
 *             .hibernateSupport("Enabled")
 *             .imageReference(Map.of("id", "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/Example/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/contosogallery/images/exampleImage/version/1.0.0"))
 *             .location("centralus")
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Preview"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:DevBoxDefinition WebDevBox /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/devboxdefinitions/{devBoxDefinitionName}
 * ```
 */
public class DevBoxDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.DevBoxDefinition,
) : KotlinCustomResource(javaResource, DevBoxDefinitionMapper) {
    /**
     * Image reference information for the currently active image (only populated during updates).
     */
    public val activeImageReference: Output<ImageReferenceResponse>
        get() = javaResource.activeImageReference().applyValue({ args0 ->
            args0.let({ args0 ->
                imageReferenceResponseToKotlin(args0)
            })
        })

    /**
     * Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate
     */
    public val hibernateSupport: Output<String>?
        get() = javaResource.hibernateSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Image reference information.
     */
    public val imageReference: Output<ImageReferenceResponse>
        get() = javaResource.imageReference().applyValue({ args0 ->
            args0.let({ args0 ->
                imageReferenceResponseToKotlin(args0)
            })
        })

    /**
     * Details for image validator error. Populated when the image validation is not successful.
     */
    public val imageValidationErrorDetails: Output<ImageValidationErrorDetailsResponse>
        get() = javaResource.imageValidationErrorDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                imageValidationErrorDetailsResponseToKotlin(args0)
            })
        })

    /**
     * Validation status of the configured image.
     */
    public val imageValidationStatus: Output<String>
        get() = javaResource.imageValidationStatus().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The storage type used for the Operating System disk of Dev Boxes created using this definition.
     */
    public val osStorageType: Output<String>?
        get() = javaResource.osStorageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SKU for Dev Boxes created using this definition.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DevBoxDefinitionMapper : ResourceMapper<DevBoxDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.DevBoxDefinition::class == javaResource::class

    override fun map(javaResource: Resource): DevBoxDefinition = DevBoxDefinition(
        javaResource as
            com.pulumi.azurenative.devcenter.DevBoxDefinition,
    )
}

/**
 * @see [DevBoxDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevBoxDefinition].
 */
public suspend fun devBoxDefinition(
    name: String,
    block: suspend DevBoxDefinitionResourceBuilder.() -> Unit,
): DevBoxDefinition {
    val builder = DevBoxDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevBoxDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devBoxDefinition(name: String): DevBoxDefinition {
    val builder = DevBoxDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
