@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.ProjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a project resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Projects_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var project = new AzureNative.DevCenter.Project("project", new()
 *     {
 *         Description = "This is my first project.",
 *         DevCenterId = "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso",
 *         Location = "centralus",
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "CostCenter", "R&D" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewProject(ctx, "project", &devcenter.ProjectArgs{
 * 			Description:       pulumi.String("This is my first project."),
 * 			DevCenterId:       pulumi.String("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso"),
 * 			Location:          pulumi.String("centralus"),
 * 			ProjectName:       pulumi.String("DevProject"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"CostCenter": pulumi.String("R&D"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Project;
 * import com.pulumi.azurenative.devcenter.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var project = new Project("project", ProjectArgs.builder()
 *             .description("This is my first project.")
 *             .devCenterId("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso")
 *             .location("centralus")
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("CostCenter", "R&D"))
 *             .build());
 *     }
 * }
 * ```
 * ### Projects_CreateOrUpdateWithLimitsPerDev
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var project = new AzureNative.DevCenter.Project("project", new()
 *     {
 *         Description = "This is my first project.",
 *         DevCenterId = "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso",
 *         Location = "centralus",
 *         MaxDevBoxesPerUser = 3,
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "CostCenter", "R&D" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewProject(ctx, "project", &devcenter.ProjectArgs{
 * 			Description:        pulumi.String("This is my first project."),
 * 			DevCenterId:        pulumi.String("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso"),
 * 			Location:           pulumi.String("centralus"),
 * 			MaxDevBoxesPerUser: pulumi.Int(3),
 * 			ProjectName:        pulumi.String("DevProject"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"CostCenter": pulumi.String("R&D"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Project;
 * import com.pulumi.azurenative.devcenter.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var project = new Project("project", ProjectArgs.builder()
 *             .description("This is my first project.")
 *             .devCenterId("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso")
 *             .location("centralus")
 *             .maxDevBoxesPerUser(3)
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("CostCenter", "R&D"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Project DevProject /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}
 * ```
 * @property description Description of the project.
 * @property devCenterId Resource Id of an associated DevCenter
 * @property location The geo-location where the resource lives
 * @property maxDevBoxesPerUser When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project. This will have no effect on existing Dev Boxes when reduced.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ProjectArgs(
    public val description: Output<String>? = null,
    public val devCenterId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val maxDevBoxesPerUser: Output<Int>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.ProjectArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.ProjectArgs =
        com.pulumi.azurenative.devcenter.ProjectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .devCenterId(devCenterId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maxDevBoxesPerUser(maxDevBoxesPerUser?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var devCenterId: Output<String>? = null

    private var location: Output<String>? = null

    private var maxDevBoxesPerUser: Output<Int>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the project.
     */
    @JvmName("urhbvljpwsoyoptp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Resource Id of an associated DevCenter
     */
    @JvmName("bauhdpacyangdtkg")
    public suspend fun devCenterId(`value`: Output<String>) {
        this.devCenterId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wlobpbhalmrhlrix")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project. This will have no effect on existing Dev Boxes when reduced.
     */
    @JvmName("guuliwbyfeshmidl")
    public suspend fun maxDevBoxesPerUser(`value`: Output<Int>) {
        this.maxDevBoxesPerUser = value
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("jetdoswjclvdirdy")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nsjkjwvwiviurpmh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("txekunpgidspdwpn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the project.
     */
    @JvmName("qkgkibwmhohyfgto")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Resource Id of an associated DevCenter
     */
    @JvmName("msbquqfddksklpdp")
    public suspend fun devCenterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devCenterId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pntofhmdbhmfmaux")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project. This will have no effect on existing Dev Boxes when reduced.
     */
    @JvmName("wwauphikhdprnnse")
    public suspend fun maxDevBoxesPerUser(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDevBoxesPerUser = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("cqmdinfrofnsegfo")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("opirrvqpboqcaftt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pvmrrwtllprkeuyx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qbkheafluqruqwjh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        description = description,
        devCenterId = devCenterId,
        location = location,
        maxDevBoxesPerUser = maxDevBoxesPerUser,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
