@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.ProjectEnvironmentTypeArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.EnvironmentTypeEnableStatus
import com.pulumi.azurenative.devcenter.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.UserRoleAssignmentArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.UserRoleAssignmentArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an environment type.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:ProjectEnvironmentType DevTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/environmentTypes/{environmentTypeName}
 * ```
 * @property creatorRoleAssignment The role definition assigned to the environment creator on backing resources.
 * @property deploymentTargetId Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this subscription.
 * @property environmentTypeName The name of the environment type.
 * @property identity Managed identity properties
 * @property location The geo-location for the environment type
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property status Defines whether this Environment Type can be used in this Project.
 * @property tags Resource tags.
 * @property userRoleAssignments Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role definition IDs.
 */
public data class ProjectEnvironmentTypeArgs(
    public val creatorRoleAssignment:
    Output<ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs>? = null,
    public val deploymentTargetId: Output<String>? = null,
    public val environmentTypeName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, EnvironmentTypeEnableStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userRoleAssignments: Output<Map<String, UserRoleAssignmentArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.ProjectEnvironmentTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.ProjectEnvironmentTypeArgs =
        com.pulumi.azurenative.devcenter.ProjectEnvironmentTypeArgs.builder()
            .creatorRoleAssignment(
                creatorRoleAssignment?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deploymentTargetId(deploymentTargetId?.applyValue({ args0 -> args0 }))
            .environmentTypeName(environmentTypeName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userRoleAssignments(
                userRoleAssignments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProjectEnvironmentTypeArgs].
 */
@PulumiTagMarker
public class ProjectEnvironmentTypeArgsBuilder internal constructor() {
    private var creatorRoleAssignment:
        Output<ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs>? = null

    private var deploymentTargetId: Output<String>? = null

    private var environmentTypeName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, EnvironmentTypeEnableStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userRoleAssignments: Output<Map<String, UserRoleAssignmentArgs>>? = null

    /**
     * @param value The role definition assigned to the environment creator on backing resources.
     */
    @JvmName("gxvicggqxxgshrtl")
    public suspend
    fun creatorRoleAssignment(`value`: Output<ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs>) {
        this.creatorRoleAssignment = value
    }

    /**
     * @param value Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this subscription.
     */
    @JvmName("vfnfwrpijfpsoabq")
    public suspend fun deploymentTargetId(`value`: Output<String>) {
        this.deploymentTargetId = value
    }

    /**
     * @param value The name of the environment type.
     */
    @JvmName("gkldbafhjdkqvetd")
    public suspend fun environmentTypeName(`value`: Output<String>) {
        this.environmentTypeName = value
    }

    /**
     * @param value Managed identity properties
     */
    @JvmName("qhobvekpocesmcsh")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location for the environment type
     */
    @JvmName("qtlxyjhfgucotofh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("dvrlhlvslwwwvxcf")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sutksxrdwkjlaaes")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Defines whether this Environment Type can be used in this Project.
     */
    @JvmName("ttxsurlnwmhwqveq")
    public suspend fun status(`value`: Output<Either<String, EnvironmentTypeEnableStatus>>) {
        this.status = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tvacectefacxakgg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role definition IDs.
     */
    @JvmName("uiljpmoiskqathgc")
    public suspend fun userRoleAssignments(`value`: Output<Map<String, UserRoleAssignmentArgs>>) {
        this.userRoleAssignments = value
    }

    /**
     * @param value The role definition assigned to the environment creator on backing resources.
     */
    @JvmName("jkmxyghftogtnedd")
    public suspend
    fun creatorRoleAssignment(`value`: ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creatorRoleAssignment = mapped
    }

    /**
     * @param argument The role definition assigned to the environment creator on backing resources.
     */
    @JvmName("gdfbsnyngwketlud")
    public suspend
    fun creatorRoleAssignment(argument: suspend ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgsBuilder.() -> Unit) {
        val toBeMapped =
            ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.creatorRoleAssignment = mapped
    }

    /**
     * @param value Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this subscription.
     */
    @JvmName("niobgkkmfubnjdis")
    public suspend fun deploymentTargetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentTargetId = mapped
    }

    /**
     * @param value The name of the environment type.
     */
    @JvmName("cessdrcnwoenwgue")
    public suspend fun environmentTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentTypeName = mapped
    }

    /**
     * @param value Managed identity properties
     */
    @JvmName("irtnawduoapoysgj")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties
     */
    @JvmName("pxlieabqkrnypryu")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location for the environment type
     */
    @JvmName("fvosoryjuxgoawss")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("gnnrnruxsxekqhfj")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vdtllmbpelgdgowa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Defines whether this Environment Type can be used in this Project.
     */
    @JvmName("fvrklsqxcukccujt")
    public suspend fun status(`value`: Either<String, EnvironmentTypeEnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Defines whether this Environment Type can be used in this Project.
     */
    @JvmName("smmivxbwabilnqtv")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnvironmentTypeEnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Defines whether this Environment Type can be used in this Project.
     */
    @JvmName("hdiufltklganpoqo")
    public fun status(`value`: EnvironmentTypeEnableStatus) {
        val toBeMapped = Either.ofRight<String, EnvironmentTypeEnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("onkhmpjqodtncwip")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gaihfllcojhhveof")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role definition IDs.
     */
    @JvmName("ihactbaishtqdamr")
    public suspend fun userRoleAssignments(`value`: Map<String, UserRoleAssignmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userRoleAssignments = mapped
    }

    /**
     * @param argument Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role definition IDs.
     */
    @JvmName("ixocijyepgjpjdxm")
    public suspend fun userRoleAssignments(
        vararg
        argument: Pair<String, suspend UserRoleAssignmentArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserRoleAssignmentArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.userRoleAssignments = mapped
    }

    /**
     * @param values Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role definition IDs.
     */
    @JvmName("lxlpffgakclpdufj")
    public fun userRoleAssignments(vararg values: Pair<String, UserRoleAssignmentArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userRoleAssignments = mapped
    }

    internal fun build(): ProjectEnvironmentTypeArgs = ProjectEnvironmentTypeArgs(
        creatorRoleAssignment = creatorRoleAssignment,
        deploymentTargetId = deploymentTargetId,
        environmentTypeName = environmentTypeName,
        identity = identity,
        location = location,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        status = status,
        tags = tags,
        userRoleAssignments = userRoleAssignments,
    )
}
