@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetAttachedNetworkByDevCenterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attachedNetworkConnectionName The name of the attached NetworkConnection.
 * @property devCenterName The name of the devcenter.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAttachedNetworkByDevCenterPlainArgs(
    public val attachedNetworkConnectionName: String,
    public val devCenterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetAttachedNetworkByDevCenterPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.devcenter.inputs.GetAttachedNetworkByDevCenterPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetAttachedNetworkByDevCenterPlainArgs.builder()
            .attachedNetworkConnectionName(attachedNetworkConnectionName.let({ args0 -> args0 }))
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttachedNetworkByDevCenterPlainArgs].
 */
@PulumiTagMarker
public class GetAttachedNetworkByDevCenterPlainArgsBuilder internal constructor() {
    private var attachedNetworkConnectionName: String? = null

    private var devCenterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the attached NetworkConnection.
     */
    @JvmName("xyxfbevvmhkxwkbe")
    public suspend fun attachedNetworkConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attachedNetworkConnectionName = mapped
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("kxaormypqrwxniok")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hoapvxcnpeqokoha")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAttachedNetworkByDevCenterPlainArgs =
        GetAttachedNetworkByDevCenterPlainArgs(
            attachedNetworkConnectionName = attachedNetworkConnectionName ?: throw
                PulumiNullFieldException("attachedNetworkConnectionName"),
            devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
