@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A role that can be assigned to a user.
 * @property description This is a description of the Role Assignment.
 * @property roleName The common name of the Role Assignment. This is a descriptive name such as 'AcrPush'.
 */
public data class EnvironmentRoleResponse(
    public val description: String,
    public val roleName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.EnvironmentRoleResponse):
            EnvironmentRoleResponse = EnvironmentRoleResponse(
            description = javaType.description(),
            roleName = javaType.roleName(),
        )
    }
}
