@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an environment type.
 * @property creatorRoleAssignment The role definition assigned to the environment creator on backing resources.
 * @property deploymentTargetId Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this subscription.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Managed identity properties
 * @property location The geo-location for the environment type
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the resource.
 * @property status Defines whether this Environment Type can be used in this Project.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userRoleAssignments Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role definition IDs.
 */
public data class GetProjectEnvironmentTypeResult(
    public val creatorRoleAssignment:
    ProjectEnvironmentTypeUpdatePropertiesResponseCreatorRoleAssignment? = null,
    public val deploymentTargetId: String? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userRoleAssignments: Map<String, UserRoleAssignmentResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetProjectEnvironmentTypeResult):
            GetProjectEnvironmentTypeResult = GetProjectEnvironmentTypeResult(
            creatorRoleAssignment = javaType.creatorRoleAssignment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.ProjectEnvironmentTypeUpdatePropertiesResponseCreatorRoleAssignment.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentTargetId = javaType.deploymentTargetId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userRoleAssignments = javaType.userRoleAssignments().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.devcenter.kotlin.outputs.UserRoleAssignmentResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
