@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a project resource.
 * @property description Description of the project.
 * @property devCenterId Resource Id of an associated DevCenter
 * @property devCenterUri The URI of the Dev Center resource this project is associated with.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property maxDevBoxesPerUser When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project. This will have no effect on existing Dev Boxes when reduced.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetProjectResult(
    public val description: String? = null,
    public val devCenterId: String? = null,
    public val devCenterUri: String,
    public val id: String,
    public val location: String,
    public val maxDevBoxesPerUser: Int? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetProjectResult):
            GetProjectResult = GetProjectResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            devCenterId = javaType.devCenterId().map({ args0 -> args0 }).orElse(null),
            devCenterUri = javaType.devCenterUri(),
            id = javaType.id(),
            location = javaType.location(),
            maxDevBoxesPerUser = javaType.maxDevBoxesPerUser().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
