@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a Schedule to execute a task.
 * @property frequency The frequency of this scheduled task.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the resource.
 * @property state Indicates whether or not this scheduled task is enabled.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property time The target time to trigger the action. The format is HH:MM.
 * @property timeZone The IANA timezone id at which the schedule should execute.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetScheduleResult(
    public val frequency: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val state: String? = null,
    public val systemData: SystemDataResponse,
    public val time: String,
    public val timeZone: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetScheduleResult):
            GetScheduleResult = GetScheduleResult(
            frequency = javaType.frequency(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            time = javaType.time(),
            timeZone = javaType.timeZone(),
            type = javaType.type(),
        )
    }
}
