@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.DeploymentPropertiesArgs.builder
import com.pulumi.azurenative.devhub.kotlin.enums.ManifestType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property helmChartPath Helm chart directory path in repository.
 * @property helmValues Helm Values.yaml file location in repository.
 * @property kubeManifestLocations
 * @property manifestType Determines the type of manifests within the repository.
 * @property overrides Manifest override values.
 */
public data class DeploymentPropertiesArgs(
    public val helmChartPath: Output<String>? = null,
    public val helmValues: Output<String>? = null,
    public val kubeManifestLocations: Output<List<String>>? = null,
    public val manifestType: Output<Either<String, ManifestType>>? = null,
    public val overrides: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.DeploymentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.DeploymentPropertiesArgs =
        com.pulumi.azurenative.devhub.inputs.DeploymentPropertiesArgs.builder()
            .helmChartPath(helmChartPath?.applyValue({ args0 -> args0 }))
            .helmValues(helmValues?.applyValue({ args0 -> args0 }))
            .kubeManifestLocations(kubeManifestLocations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .manifestType(
                manifestType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .overrides(
                overrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentPropertiesArgs].
 */
@PulumiTagMarker
public class DeploymentPropertiesArgsBuilder internal constructor() {
    private var helmChartPath: Output<String>? = null

    private var helmValues: Output<String>? = null

    private var kubeManifestLocations: Output<List<String>>? = null

    private var manifestType: Output<Either<String, ManifestType>>? = null

    private var overrides: Output<Map<String, String>>? = null

    /**
     * @param value Helm chart directory path in repository.
     */
    @JvmName("qyvtkurulqnswcpw")
    public suspend fun helmChartPath(`value`: Output<String>) {
        this.helmChartPath = value
    }

    /**
     * @param value Helm Values.yaml file location in repository.
     */
    @JvmName("xummwbfpeeakxoae")
    public suspend fun helmValues(`value`: Output<String>) {
        this.helmValues = value
    }

    /**
     * @param value
     */
    @JvmName("lgcxecmxfmvsoxgd")
    public suspend fun kubeManifestLocations(`value`: Output<List<String>>) {
        this.kubeManifestLocations = value
    }

    @JvmName("mygwkjhbmeepwpde")
    public suspend fun kubeManifestLocations(vararg values: Output<String>) {
        this.kubeManifestLocations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("otfnjdtexhqytcff")
    public suspend fun kubeManifestLocations(values: List<Output<String>>) {
        this.kubeManifestLocations = Output.all(values)
    }

    /**
     * @param value Determines the type of manifests within the repository.
     */
    @JvmName("eioouakfopfknulc")
    public suspend fun manifestType(`value`: Output<Either<String, ManifestType>>) {
        this.manifestType = value
    }

    /**
     * @param value Manifest override values.
     */
    @JvmName("tkllvyeeaqvkupfk")
    public suspend fun overrides(`value`: Output<Map<String, String>>) {
        this.overrides = value
    }

    /**
     * @param value Helm chart directory path in repository.
     */
    @JvmName("ibodjfsmbsqticwb")
    public suspend fun helmChartPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helmChartPath = mapped
    }

    /**
     * @param value Helm Values.yaml file location in repository.
     */
    @JvmName("xsyvwukbvuaoqrgn")
    public suspend fun helmValues(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helmValues = mapped
    }

    /**
     * @param value
     */
    @JvmName("xxuhhtpfrtklkjdk")
    public suspend fun kubeManifestLocations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeManifestLocations = mapped
    }

    /**
     * @param values
     */
    @JvmName("tekmnjrxxeyvrvlb")
    public suspend fun kubeManifestLocations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kubeManifestLocations = mapped
    }

    /**
     * @param value Determines the type of manifests within the repository.
     */
    @JvmName("jdxjtklgfjsylrtq")
    public suspend fun manifestType(`value`: Either<String, ManifestType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestType = mapped
    }

    /**
     * @param value Determines the type of manifests within the repository.
     */
    @JvmName("unejyooscavicyji")
    public fun manifestType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManifestType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestType = mapped
    }

    /**
     * @param value Determines the type of manifests within the repository.
     */
    @JvmName("ecbrosqkrxvvfvmh")
    public fun manifestType(`value`: ManifestType) {
        val toBeMapped = Either.ofRight<String, ManifestType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestType = mapped
    }

    /**
     * @param value Manifest override values.
     */
    @JvmName("ixxysanposqmjouf")
    public suspend fun overrides(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param values Manifest override values.
     */
    @JvmName("llhswgwsjdfwwuxb")
    public fun overrides(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    internal fun build(): DeploymentPropertiesArgs = DeploymentPropertiesArgs(
        helmChartPath = helmChartPath,
        helmValues = helmValues,
        kubeManifestLocations = kubeManifestLocations,
        manifestType = manifestType,
        overrides = overrides,
    )
}
