@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property helmChartPath Helm chart directory path in repository.
 * @property helmValues Helm Values.yaml file location in repository.
 * @property kubeManifestLocations
 * @property manifestType Determines the type of manifests within the repository.
 * @property overrides Manifest override values.
 */
public data class DeploymentPropertiesResponse(
    public val helmChartPath: String? = null,
    public val helmValues: String? = null,
    public val kubeManifestLocations: List<String>? = null,
    public val manifestType: String? = null,
    public val overrides: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.DeploymentPropertiesResponse):
            DeploymentPropertiesResponse = DeploymentPropertiesResponse(
            helmChartPath = javaType.helmChartPath().map({ args0 -> args0 }).orElse(null),
            helmValues = javaType.helmValues().map({ args0 -> args0 }).orElse(null),
            kubeManifestLocations = javaType.kubeManifestLocations().map({ args0 -> args0 }),
            manifestType = javaType.manifestType().map({ args0 -> args0 }).orElse(null),
            overrides = javaType.overrides().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
