@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin

import com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetResponseExtendedLocation
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetResponseProperties
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetResponseExtendedLocation.Companion.toKotlin as assetResponseExtendedLocationToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetResponseProperties.Companion.toKotlin as assetResponsePropertiesToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Asset].
 */
@PulumiTagMarker
public class AssetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssetArgs = AssetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssetArgsBuilder.() -> Unit) {
        val builder = AssetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Asset {
        val builtJavaResource = com.pulumi.azurenative.deviceregistry.Asset(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Asset(builtJavaResource)
    }
}

/**
 * Asset definition.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### Create an Asset With External Asset Id
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetName = "my-asset",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.AssetExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         Properties = new AzureNative.DeviceRegistry.Inputs.AssetPropertiesArgs
 *         {
 *             AssetEndpointProfileUri = "https://www.example.com/myConnectivityProfile",
 *             AssetType = "MyAssetType",
 *             DataPoints = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                     ObservabilityMode = "counter",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                     ObservabilityMode = "none",
 *                 },
 *             },
 *             DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             Description = "This is a sample Asset",
 *             DisplayName = "AssetDisplayName",
 *             DocumentationUri = "https://www.example.com/manual",
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                     ObservabilityMode = "none",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                     ObservabilityMode = "log",
 *                 },
 *             },
 *             ExternalAssetId = "8ZBA6LRHU0A458969",
 *             HardwareRevision = "1.0",
 *             Manufacturer = "Contoso",
 *             ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *             Model = "ContosoModel",
 *             ProductCode = "SA34VDG",
 *             SerialNumber = "64-103816-519918-8",
 *             SoftwareRevision = "2.0",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetName: pulumi.String("my-asset"),
 * 			ExtendedLocation: &deviceregistry.AssetExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("West Europe"),
 * 			Properties: deviceregistry.AssetResponseProperties{
 * 				AssetEndpointProfileUri: pulumi.String("https://www.example.com/myConnectivityProfile"),
 * 				AssetType:               pulumi.String("MyAssetType"),
 * 				DataPoints: deviceregistry.AssetPropertiesDataPointsArray{
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 						ObservabilityMode:      pulumi.String("counter"),
 * 					},
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 						ObservabilityMode:      pulumi.String("none"),
 * 					},
 * 				},
 * 				DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				Description:                    pulumi.String("This is a sample Asset"),
 * 				DisplayName:                    pulumi.String("AssetDisplayName"),
 * 				DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 				Enabled:                        pulumi.Bool(true),
 * 				Events: deviceregistry.AssetPropertiesEventsArray{
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 						ObservabilityMode:  pulumi.String("none"),
 * 					},
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 						ObservabilityMode:  pulumi.String("log"),
 * 					},
 * 				},
 * 				ExternalAssetId:  pulumi.String("8ZBA6LRHU0A458969"),
 * 				HardwareRevision: pulumi.String("1.0"),
 * 				Manufacturer:     pulumi.String("Contoso"),
 * 				ManufacturerUri:  pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 				Model:            pulumi.String("ContosoModel"),
 * 				ProductCode:      pulumi.String("SA34VDG"),
 * 				SerialNumber:     pulumi.String("64-103816-519918-8"),
 * 				SoftwareRevision: pulumi.String("2.0"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetName("my-asset")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West Europe")
 *             .properties(Map.ofEntries(
 *                 Map.entry("assetEndpointProfileUri", "https://www.example.com/myConnectivityProfile"),
 *                 Map.entry("assetType", "MyAssetType"),
 *                 Map.entry("dataPoints",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 *                         Map.entry("observabilityMode", "counter")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 *                         Map.entry("observabilityMode", "none")
 *                     )),
 *                 Map.entry("defaultDataPointsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("defaultEventsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("description", "This is a sample Asset"),
 *                 Map.entry("displayName", "AssetDisplayName"),
 *                 Map.entry("documentationUri", "https://www.example.com/manual"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("events",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 *                         Map.entry("observabilityMode", "none")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 *                         Map.entry("observabilityMode", "log")
 *                     )),
 *                 Map.entry("externalAssetId", "8ZBA6LRHU0A458969"),
 *                 Map.entry("hardwareRevision", "1.0"),
 *                 Map.entry("manufacturer", "Contoso"),
 *                 Map.entry("manufacturerUri", "https://www.contoso.com/manufacturerUri"),
 *                 Map.entry("model", "ContosoModel"),
 *                 Map.entry("productCode", "SA34VDG"),
 *                 Map.entry("serialNumber", "64-103816-519918-8"),
 *                 Map.entry("softwareRevision", "2.0")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset Without Display Name
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetName = "my-asset",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.AssetExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         Properties = new AzureNative.DeviceRegistry.Inputs.AssetPropertiesArgs
 *         {
 *             AssetEndpointProfileUri = "https://www.example.com/myConnectivityProfile",
 *             AssetType = "MyAssetType",
 *             DataPoints = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                     ObservabilityMode = "counter",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                     ObservabilityMode = "none",
 *                 },
 *             },
 *             DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             Description = "This is a sample Asset",
 *             DocumentationUri = "https://www.example.com/manual",
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                     ObservabilityMode = "none",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                     ObservabilityMode = "log",
 *                 },
 *             },
 *             ExternalAssetId = "8ZBA6LRHU0A458969",
 *             HardwareRevision = "1.0",
 *             Manufacturer = "Contoso",
 *             ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *             Model = "ContosoModel",
 *             ProductCode = "SA34VDG",
 *             SerialNumber = "64-103816-519918-8",
 *             SoftwareRevision = "2.0",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetName: pulumi.String("my-asset"),
 * 			ExtendedLocation: &deviceregistry.AssetExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("West Europe"),
 * 			Properties: deviceregistry.AssetResponseProperties{
 * 				AssetEndpointProfileUri: pulumi.String("https://www.example.com/myConnectivityProfile"),
 * 				AssetType:               pulumi.String("MyAssetType"),
 * 				DataPoints: deviceregistry.AssetPropertiesDataPointsArray{
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 						ObservabilityMode:      pulumi.String("counter"),
 * 					},
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 						ObservabilityMode:      pulumi.String("none"),
 * 					},
 * 				},
 * 				DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				Description:                    pulumi.String("This is a sample Asset"),
 * 				DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 				Enabled:                        pulumi.Bool(true),
 * 				Events: deviceregistry.AssetPropertiesEventsArray{
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 						ObservabilityMode:  pulumi.String("none"),
 * 					},
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 						ObservabilityMode:  pulumi.String("log"),
 * 					},
 * 				},
 * 				ExternalAssetId:  pulumi.String("8ZBA6LRHU0A458969"),
 * 				HardwareRevision: pulumi.String("1.0"),
 * 				Manufacturer:     pulumi.String("Contoso"),
 * 				ManufacturerUri:  pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 				Model:            pulumi.String("ContosoModel"),
 * 				ProductCode:      pulumi.String("SA34VDG"),
 * 				SerialNumber:     pulumi.String("64-103816-519918-8"),
 * 				SoftwareRevision: pulumi.String("2.0"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetName("my-asset")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West Europe")
 *             .properties(Map.ofEntries(
 *                 Map.entry("assetEndpointProfileUri", "https://www.example.com/myConnectivityProfile"),
 *                 Map.entry("assetType", "MyAssetType"),
 *                 Map.entry("dataPoints",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 *                         Map.entry("observabilityMode", "counter")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 *                         Map.entry("observabilityMode", "none")
 *                     )),
 *                 Map.entry("defaultDataPointsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("defaultEventsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("description", "This is a sample Asset"),
 *                 Map.entry("documentationUri", "https://www.example.com/manual"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("events",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 *                         Map.entry("observabilityMode", "none")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 *                         Map.entry("observabilityMode", "log")
 *                     )),
 *                 Map.entry("externalAssetId", "8ZBA6LRHU0A458969"),
 *                 Map.entry("hardwareRevision", "1.0"),
 *                 Map.entry("manufacturer", "Contoso"),
 *                 Map.entry("manufacturerUri", "https://www.contoso.com/manufacturerUri"),
 *                 Map.entry("model", "ContosoModel"),
 *                 Map.entry("productCode", "SA34VDG"),
 *                 Map.entry("serialNumber", "64-103816-519918-8"),
 *                 Map.entry("softwareRevision", "2.0")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset Without External Asset Id
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetName = "my-asset",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.AssetExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         Properties = new AzureNative.DeviceRegistry.Inputs.AssetPropertiesArgs
 *         {
 *             AssetEndpointProfileUri = "https://www.example.com/myConnectivityProfile",
 *             AssetType = "MyAssetType",
 *             DataPoints = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                     ObservabilityMode = "counter",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                     ObservabilityMode = "none",
 *                 },
 *             },
 *             DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             Description = "This is a sample Asset",
 *             DisplayName = "AssetDisplayName",
 *             DocumentationUri = "https://www.example.com/manual",
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                     ObservabilityMode = "none",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                     ObservabilityMode = "log",
 *                 },
 *             },
 *             HardwareRevision = "1.0",
 *             Manufacturer = "Contoso",
 *             ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *             Model = "ContosoModel",
 *             ProductCode = "SA34VDG",
 *             SerialNumber = "64-103816-519918-8",
 *             SoftwareRevision = "2.0",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetName: pulumi.String("my-asset"),
 * 			ExtendedLocation: &deviceregistry.AssetExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("West Europe"),
 * 			Properties: deviceregistry.AssetResponseProperties{
 * 				AssetEndpointProfileUri: pulumi.String("https://www.example.com/myConnectivityProfile"),
 * 				AssetType:               pulumi.String("MyAssetType"),
 * 				DataPoints: deviceregistry.AssetPropertiesDataPointsArray{
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 						ObservabilityMode:      pulumi.String("counter"),
 * 					},
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 						ObservabilityMode:      pulumi.String("none"),
 * 					},
 * 				},
 * 				DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				Description:                    pulumi.String("This is a sample Asset"),
 * 				DisplayName:                    pulumi.String("AssetDisplayName"),
 * 				DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 				Enabled:                        pulumi.Bool(true),
 * 				Events: deviceregistry.AssetPropertiesEventsArray{
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 						ObservabilityMode:  pulumi.String("none"),
 * 					},
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 						ObservabilityMode:  pulumi.String("log"),
 * 					},
 * 				},
 * 				HardwareRevision: pulumi.String("1.0"),
 * 				Manufacturer:     pulumi.String("Contoso"),
 * 				ManufacturerUri:  pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 				Model:            pulumi.String("ContosoModel"),
 * 				ProductCode:      pulumi.String("SA34VDG"),
 * 				SerialNumber:     pulumi.String("64-103816-519918-8"),
 * 				SoftwareRevision: pulumi.String("2.0"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetName("my-asset")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West Europe")
 *             .properties(Map.ofEntries(
 *                 Map.entry("assetEndpointProfileUri", "https://www.example.com/myConnectivityProfile"),
 *                 Map.entry("assetType", "MyAssetType"),
 *                 Map.entry("dataPoints",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 *                         Map.entry("observabilityMode", "counter")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 *                         Map.entry("observabilityMode", "none")
 *                     )),
 *                 Map.entry("defaultDataPointsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("defaultEventsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("description", "This is a sample Asset"),
 *                 Map.entry("displayName", "AssetDisplayName"),
 *                 Map.entry("documentationUri", "https://www.example.com/manual"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("events",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 *                         Map.entry("observabilityMode", "none")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 *                         Map.entry("observabilityMode", "log")
 *                     )),
 *                 Map.entry("hardwareRevision", "1.0"),
 *                 Map.entry("manufacturer", "Contoso"),
 *                 Map.entry("manufacturerUri", "https://www.contoso.com/manufacturerUri"),
 *                 Map.entry("model", "ContosoModel"),
 *                 Map.entry("productCode", "SA34VDG"),
 *                 Map.entry("serialNumber", "64-103816-519918-8"),
 *                 Map.entry("softwareRevision", "2.0")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceregistry:Asset my-asset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assets/{assetName}
 * ```
 */
public class Asset internal constructor(
    override val javaResource: com.pulumi.azurenative.deviceregistry.Asset,
) : KotlinCustomResource(javaResource, AssetMapper) {
    /**
     * The extended location.
     */
    public val extendedLocation: Output<AssetResponseExtendedLocation>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                assetResponseExtendedLocationToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Asset resource properties.
     */
    public val properties: Output<AssetResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                assetResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AssetMapper : ResourceMapper<Asset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deviceregistry.Asset::class == javaResource::class

    override fun map(javaResource: Resource): Asset = Asset(
        javaResource as
            com.pulumi.azurenative.deviceregistry.Asset,
    )
}

/**
 * @see [Asset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Asset].
 */
public suspend fun asset(name: String, block: suspend AssetResourceBuilder.() -> Unit): Asset {
    val builder = AssetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Asset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun asset(name: String): Asset {
    val builder = AssetResourceBuilder()
    builder.name(name)
    return builder.build()
}
