@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines the mode to authenticate the user of the client at the server.
 */
public enum class Mode(
    public val javaValue: com.pulumi.azurenative.deviceregistry.enums.Mode,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.enums.Mode> {
    Anonymous(com.pulumi.azurenative.deviceregistry.enums.Mode.Anonymous),
    Certificate(com.pulumi.azurenative.deviceregistry.enums.Mode.Certificate),
    UsernamePassword(com.pulumi.azurenative.deviceregistry.enums.Mode.UsernamePassword),
    ;

    override fun toJava(): com.pulumi.azurenative.deviceregistry.enums.Mode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.enums.Mode): Mode =
            Mode.values().first { it.javaValue == javaType }
    }
}
