@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Asset resource properties.
 * @property assetEndpointProfileUri A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
 * @property assetType Resource path to asset type (model) definition.
 * @property attributes A set of key-value pairs that contain custom attributes set by the customer.
 * @property dataPoints Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
 * @property defaultDataPointsConfiguration Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
 * @property defaultEventsConfiguration Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
 * @property description Human-readable description of the asset.
 * @property displayName Human-readable display name.
 * @property documentationUri Reference to the documentation.
 * @property enabled Enabled/Disabled status of the asset.
 * @property events Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
 * @property externalAssetId Asset id provided by the customer.
 * @property hardwareRevision Revision number of the hardware.
 * @property manufacturer Asset manufacturer name.
 * @property manufacturerUri Asset manufacturer URI.
 * @property model Asset model name.
 * @property productCode Asset product code.
 * @property serialNumber Asset serial number.
 * @property softwareRevision Revision number of the software.
 */
public data class AssetPropertiesArgs(
    public val assetEndpointProfileUri: Output<String>,
    public val assetType: Output<String>? = null,
    public val attributes: Output<Any>? = null,
    public val dataPoints: Output<List<AssetPropertiesDataPointsArgs>>? = null,
    public val defaultDataPointsConfiguration: Output<String>? = null,
    public val defaultEventsConfiguration: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val documentationUri: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val events: Output<List<AssetPropertiesEventsArgs>>? = null,
    public val externalAssetId: Output<String>? = null,
    public val hardwareRevision: Output<String>? = null,
    public val manufacturer: Output<String>? = null,
    public val manufacturerUri: Output<String>? = null,
    public val model: Output<String>? = null,
    public val productCode: Output<String>? = null,
    public val serialNumber: Output<String>? = null,
    public val softwareRevision: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesArgs.builder()
            .assetEndpointProfileUri(assetEndpointProfileUri.applyValue({ args0 -> args0 }))
            .assetType(assetType?.applyValue({ args0 -> args0 }))
            .attributes(attributes?.applyValue({ args0 -> args0 }))
            .dataPoints(
                dataPoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultDataPointsConfiguration(defaultDataPointsConfiguration?.applyValue({ args0 -> args0 }))
            .defaultEventsConfiguration(defaultEventsConfiguration?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .documentationUri(documentationUri?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .events(events?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .externalAssetId(externalAssetId?.applyValue({ args0 -> args0 }))
            .hardwareRevision(hardwareRevision?.applyValue({ args0 -> args0 }))
            .manufacturer(manufacturer?.applyValue({ args0 -> args0 }))
            .manufacturerUri(manufacturerUri?.applyValue({ args0 -> args0 }))
            .model(model?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 }))
            .softwareRevision(softwareRevision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssetPropertiesArgs].
 */
@PulumiTagMarker
public class AssetPropertiesArgsBuilder internal constructor() {
    private var assetEndpointProfileUri: Output<String>? = null

    private var assetType: Output<String>? = null

    private var attributes: Output<Any>? = null

    private var dataPoints: Output<List<AssetPropertiesDataPointsArgs>>? = null

    private var defaultDataPointsConfiguration: Output<String>? = null

    private var defaultEventsConfiguration: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var documentationUri: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var events: Output<List<AssetPropertiesEventsArgs>>? = null

    private var externalAssetId: Output<String>? = null

    private var hardwareRevision: Output<String>? = null

    private var manufacturer: Output<String>? = null

    private var manufacturerUri: Output<String>? = null

    private var model: Output<String>? = null

    private var productCode: Output<String>? = null

    private var serialNumber: Output<String>? = null

    private var softwareRevision: Output<String>? = null

    /**
     * @param value A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
     */
    @JvmName("hqfmvsodiikywwuw")
    public suspend fun assetEndpointProfileUri(`value`: Output<String>) {
        this.assetEndpointProfileUri = value
    }

    /**
     * @param value Resource path to asset type (model) definition.
     */
    @JvmName("qkihkddvhpcksoum")
    public suspend fun assetType(`value`: Output<String>) {
        this.assetType = value
    }

    /**
     * @param value A set of key-value pairs that contain custom attributes set by the customer.
     */
    @JvmName("qewosqqjjvqafprm")
    public suspend fun attributes(`value`: Output<Any>) {
        this.attributes = value
    }

    /**
     * @param value Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("wimimxetqyojfnwp")
    public suspend fun dataPoints(`value`: Output<List<AssetPropertiesDataPointsArgs>>) {
        this.dataPoints = value
    }

    @JvmName("jogogubeuuiivxks")
    public suspend fun dataPoints(vararg values: Output<AssetPropertiesDataPointsArgs>) {
        this.dataPoints = Output.all(values.asList())
    }

    /**
     * @param values Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("tylrtspsjrfkbkbj")
    public suspend fun dataPoints(values: List<Output<AssetPropertiesDataPointsArgs>>) {
        this.dataPoints = Output.all(values)
    }

    /**
     * @param value Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("llulehtmqfaondta")
    public suspend fun defaultDataPointsConfiguration(`value`: Output<String>) {
        this.defaultDataPointsConfiguration = value
    }

    /**
     * @param value Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("vswbntuybinfijcp")
    public suspend fun defaultEventsConfiguration(`value`: Output<String>) {
        this.defaultEventsConfiguration = value
    }

    /**
     * @param value Human-readable description of the asset.
     */
    @JvmName("jqorejviqnxjjtya")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Human-readable display name.
     */
    @JvmName("icddayxxouhyuwjk")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Reference to the documentation.
     */
    @JvmName("oxdkgflgnxduqjox")
    public suspend fun documentationUri(`value`: Output<String>) {
        this.documentationUri = value
    }

    /**
     * @param value Enabled/Disabled status of the asset.
     */
    @JvmName("oqofidhxvdmfvgcw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("gjxnnamwidoojpiv")
    public suspend fun events(`value`: Output<List<AssetPropertiesEventsArgs>>) {
        this.events = value
    }

    @JvmName("wngqsmmnmixhulfw")
    public suspend fun events(vararg values: Output<AssetPropertiesEventsArgs>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("xiptaytgivjlimxh")
    public suspend fun events(values: List<Output<AssetPropertiesEventsArgs>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value Asset id provided by the customer.
     */
    @JvmName("tsjeynnutnpahqyr")
    public suspend fun externalAssetId(`value`: Output<String>) {
        this.externalAssetId = value
    }

    /**
     * @param value Revision number of the hardware.
     */
    @JvmName("cyucpsubioulevem")
    public suspend fun hardwareRevision(`value`: Output<String>) {
        this.hardwareRevision = value
    }

    /**
     * @param value Asset manufacturer name.
     */
    @JvmName("tnndgpyqruwdodex")
    public suspend fun manufacturer(`value`: Output<String>) {
        this.manufacturer = value
    }

    /**
     * @param value Asset manufacturer URI.
     */
    @JvmName("kdnxoyepjsiuvbiq")
    public suspend fun manufacturerUri(`value`: Output<String>) {
        this.manufacturerUri = value
    }

    /**
     * @param value Asset model name.
     */
    @JvmName("peftvxxuuccumkau")
    public suspend fun model(`value`: Output<String>) {
        this.model = value
    }

    /**
     * @param value Asset product code.
     */
    @JvmName("brkwostvldpcukwq")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value Asset serial number.
     */
    @JvmName("uuctujgrdeaupfbt")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value Revision number of the software.
     */
    @JvmName("gfppcjqjaiysifgu")
    public suspend fun softwareRevision(`value`: Output<String>) {
        this.softwareRevision = value
    }

    /**
     * @param value A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
     */
    @JvmName("hdyefgokyytjakij")
    public suspend fun assetEndpointProfileUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assetEndpointProfileUri = mapped
    }

    /**
     * @param value Resource path to asset type (model) definition.
     */
    @JvmName("bkwhkmsdevaqbgoc")
    public suspend fun assetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetType = mapped
    }

    /**
     * @param value A set of key-value pairs that contain custom attributes set by the customer.
     */
    @JvmName("ugbptstbtnihqwvj")
    public suspend fun attributes(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("xkodhlyrnwbgwnlk")
    public suspend fun dataPoints(`value`: List<AssetPropertiesDataPointsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("gsaeyjtknyhrarla")
    public suspend
    fun dataPoints(argument: List<suspend AssetPropertiesDataPointsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssetPropertiesDataPointsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("lhdjmlfiuffurwtu")
    public suspend fun dataPoints(
        vararg
        argument: suspend AssetPropertiesDataPointsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AssetPropertiesDataPointsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("biytfrdcgewxbosb")
    public suspend fun dataPoints(argument: suspend AssetPropertiesDataPointsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AssetPropertiesDataPointsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param values Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("yguwnxiwuycnjpsb")
    public suspend fun dataPoints(vararg values: AssetPropertiesDataPointsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPoints = mapped
    }

    /**
     * @param value Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("uutjicrdpgbpuxyq")
    public suspend fun defaultDataPointsConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDataPointsConfiguration = mapped
    }

    /**
     * @param value Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("xmkbvpxcndiowepg")
    public suspend fun defaultEventsConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultEventsConfiguration = mapped
    }

    /**
     * @param value Human-readable description of the asset.
     */
    @JvmName("jpkyvssgkcpnwvgr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Human-readable display name.
     */
    @JvmName("wghxgswimfhwohtf")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Reference to the documentation.
     */
    @JvmName("sydntaeirsymjcjm")
    public suspend fun documentationUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentationUri = mapped
    }

    /**
     * @param value Enabled/Disabled status of the asset.
     */
    @JvmName("imrirodnrojeoneb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("iupxnsnrvvcwplrh")
    public suspend fun events(`value`: List<AssetPropertiesEventsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("tauhjxjtfdiqsupw")
    public suspend fun events(argument: List<suspend AssetPropertiesEventsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssetPropertiesEventsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("oeuvrgcocqpwcpjw")
    public suspend fun events(vararg argument: suspend AssetPropertiesEventsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssetPropertiesEventsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("qenlhdicwtbtkgvn")
    public suspend fun events(argument: suspend AssetPropertiesEventsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AssetPropertiesEventsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param values Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("yxmhrarlwcpneshy")
    public suspend fun events(vararg values: AssetPropertiesEventsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value Asset id provided by the customer.
     */
    @JvmName("hhokqjuxtfinubtc")
    public suspend fun externalAssetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAssetId = mapped
    }

    /**
     * @param value Revision number of the hardware.
     */
    @JvmName("pbfxgatywsynqswg")
    public suspend fun hardwareRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareRevision = mapped
    }

    /**
     * @param value Asset manufacturer name.
     */
    @JvmName("pxwoamgsujafyotf")
    public suspend fun manufacturer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manufacturer = mapped
    }

    /**
     * @param value Asset manufacturer URI.
     */
    @JvmName("wivuiphhaucktxen")
    public suspend fun manufacturerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manufacturerUri = mapped
    }

    /**
     * @param value Asset model name.
     */
    @JvmName("xxfdeintdvwthrxw")
    public suspend fun model(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param value Asset product code.
     */
    @JvmName("gkgyberqjbxqwbfk")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value Asset serial number.
     */
    @JvmName("gqeykegxgarpvjxq")
    public suspend fun serialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value Revision number of the software.
     */
    @JvmName("lkviwvwmdfnucybg")
    public suspend fun softwareRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareRevision = mapped
    }

    internal fun build(): AssetPropertiesArgs = AssetPropertiesArgs(
        assetEndpointProfileUri = assetEndpointProfileUri ?: throw
            PulumiNullFieldException("assetEndpointProfileUri"),
        assetType = assetType,
        attributes = attributes,
        dataPoints = dataPoints,
        defaultDataPointsConfiguration = defaultDataPointsConfiguration,
        defaultEventsConfiguration = defaultEventsConfiguration,
        description = description,
        displayName = displayName,
        documentationUri = documentationUri,
        enabled = enabled,
        events = events,
        externalAssetId = externalAssetId,
        hardwareRevision = hardwareRevision,
        manufacturer = manufacturer,
        manufacturerUri = manufacturerUri,
        model = model,
        productCode = productCode,
        serialNumber = serialNumber,
        softwareRevision = softwareRevision,
    )
}
