@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.GetAssetEndpointProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assetEndpointProfileName Asset Endpoint Profile name parameter.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAssetEndpointProfilePlainArgs(
    public val assetEndpointProfileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.GetAssetEndpointProfilePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.deviceregistry.inputs.GetAssetEndpointProfilePlainArgs =
        com.pulumi.azurenative.deviceregistry.inputs.GetAssetEndpointProfilePlainArgs.builder()
            .assetEndpointProfileName(assetEndpointProfileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssetEndpointProfilePlainArgs].
 */
@PulumiTagMarker
public class GetAssetEndpointProfilePlainArgsBuilder internal constructor() {
    private var assetEndpointProfileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Asset Endpoint Profile name parameter.
     */
    @JvmName("psdggxpqwjnsqemt")
    public suspend fun assetEndpointProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assetEndpointProfileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("krgvcptsbvbgqfqd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAssetEndpointProfilePlainArgs = GetAssetEndpointProfilePlainArgs(
        assetEndpointProfileName = assetEndpointProfileName ?: throw
            PulumiNullFieldException("assetEndpointProfileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
